/*	Tup.H

	Tuple generating compiler in C:  Header File

	February 1990, by H. Dietz
	Modified 1994, by H. Dietz
*/

#include	<stdio.h>
#include	<ctype.h>

#define	DEBUG			/* cause debugging printfs */
#undef	DEBUG

typedef	int	konst;		/* type of a constant value */
typedef	int	label;		/* type of a label value */
typedef	int	opcode;		/* type of an opcode */

/*	Symbol table (variable) struct... */
#define	var	struct _var
var {
	char	*text;		/* pointer to string */
	int	type;		/* token type of variable (e.g., IF) */
	int	dim;		/* size of dimension (1 means scalar) */
	int	deflev;		/* scope level of definition */
	int	defblk;		/* block number of definition */
};

/*	Tuple struct... */
#define	tuple	struct _tuple
tuple {
	tuple	*next, *prev;	/* sequential order links */
	opcode	oarg;		/* tuple opcode */
	tuple	*targ[2];	/* tuple arguments */
	konst	carg;		/* constant argument */
	label	larg[2];	/* label arguments */
	var	*varg;		/* variable name argument */
};

/*	token types... */
#define	ADD	'+'
#define	SUB	'-'
#define	AND	'&'
#define	OR	'|'
#define	XOR	'^'
#define	GT	'>'
#define	GE	512
#define	EQ	513
#define	SSL	514
#define	SSR	515
#define	CONST	516
#define	LD	517
#define	LDX	518
#define	ST	519
#define	STX	520
#define	LAB	521
#define	SEL	522
#define	KILL	523

#define	WORD	524
#define	NE	525
#define	LT	'<'
#define	LE	526

#define	INT	1024
#define	IF	1025
#define	ELSE	1026
#define	WHILE	1027
#define	BREAK	1028
#define	CONT	1029
#define	UNDEF	2048

/*	Tup2.C */
extern	void	prog();		/* parser entry point */

/*	Tup3.C */
extern	int	lookt;		/* next token of input */
extern	var	*lookv;		/* next variable */
extern	konst	lookk;		/* next constant */
extern	char	looks[513];	/* next string */
extern	int nextt();		/* get next token from input */
extern	void error();		/* mutant printf */

/*	Tup4.C */
extern	int newscope();		/* make a new scope */
extern	int endscope();		/* end the current scope */
extern	void initv();		/* initialize symbol table */
extern	var *findv();		/* find var entry in symbol table */
extern	var *makev();		/* make var entry in symbol table */

/*	Tup5.C */
extern	tuple	*binop();
extern	tuple	*cop();
extern	tuple	*ldop();
extern	tuple	*ldxop();
extern	tuple	*stop();
extern	tuple	*stxop();
extern	tuple	*labop();
extern	tuple	*selop();
extern	tuple	*killop();
extern	void	codegen();
