/*	Tup5.C

	Tuple generating compiler in C:  Code Generators

	February 1990, by H. Dietz
*/

#include	"tup.h"

static	tuple	code = {
	&code, &code, UNDEF
};

extern	tuple	*binop();
extern	tuple	*cop();
extern	tuple	*ldop();
extern	tuple	*ldxop();
extern	tuple	*stop();
extern	tuple	*stxop();
extern	tuple	*labop();
extern	tuple	*selop();
extern	tuple	*killop();
extern	void	codegen();
static	void	cgbin();
static	int	ttoi();
static	tuple	*mktuple();
static	void	rmtuple();

tuple *
binop(o, t1, t2)
opcode o;
tuple *t1, *t2;
{
	register tuple *p = mktuple();

	p->oarg = o;
	p->targ[0] = t1;
	p->targ[1] = t2;
	return(p);
}

tuple *
cop(c)
konst c;
{
	register tuple *p = mktuple();

	p->oarg = CONST;
	p->carg = c;
	return(p);
}

tuple *
ldop(v)
var *v;
{
	register tuple *p = mktuple();

	p->oarg = LD;
	p->varg = v;
	return(p);
}

tuple *
ldxop(v, t)
var *v;
tuple *t;
{
	register tuple *p = mktuple();

	p->oarg = LDX;
	p->varg = v;
	p->targ[0] = t;
	return(p);
}

tuple *
stop(v, t)
var *v;
tuple *t;
{
	register tuple *p = mktuple();

	p->oarg = ST;
	p->varg = v;
	p->targ[0] = t;
	return(p);
}

tuple *
stxop(v, t1, t2)
var *v;
tuple *t1, *t2;
{
	register tuple *p = mktuple();

	p->oarg = STX;
	p->varg = v;
	p->targ[0] = t1;
	p->targ[1] = t2;
	return(p);
}

tuple *
labop(l)
label l;
{
	register tuple *p = mktuple();

	p->oarg = LAB;
	p->larg[0] = l;
	return(p);
}

tuple *
selop(t, l1, l2)
tuple *t;
label l1, l2;
{
	register tuple *p = mktuple();

	p->oarg = SEL;
	p->targ[0] = t;
	p->larg[0] = l1;
	p->larg[1] = l2;
	return(p);
}

tuple *
killop(v)
var *v;
{
	register tuple *p = mktuple();

	p->oarg = KILL;
	p->varg = v;
	return(p);
}

void
codegen()
{
	/* print listing of generated code */
	register tuple *p = code.next;

	while (p != &code) {
		printf("%d\t", ttoi(p));

		switch (p->oarg) {
		case ADD:
			cgbin("add", p);
			break;
		case SUB:
			cgbin("sub", p);
			break;
		case AND:
			cgbin("and", p);
			break;
		case OR:
			cgbin("or", p);
			break;
		case XOR:
			cgbin("xor", p);
			break;
		case GT:
			cgbin("gt", p);
			break;
		case GE:
			cgbin("ge", p);
			break;
		case EQ:
			cgbin("eq", p);
			break;
		case SSL:
			cgbin("ssl", p);
			break;
		case SSR:
			cgbin("ssr", p);
			break;
		case CONST:
			printf("const(%d)", p->carg);
			break;
		case LD:
			printf("ld(%s{%d,%d})", (p->varg)->text,
				(p->varg)->deflev, (p->varg)->defblk);
			break;
		case LDX:
			printf("ldx(%s{%d,%d}, %d)", (p->varg)->text,
				(p->varg)->deflev, (p->varg)->defblk,
				ttoi(p->targ[0]));
			break;
		case ST:
			printf("st(%s{%d,%d}, %d)", (p->varg)->text,
				(p->varg)->deflev, (p->varg)->defblk,
				ttoi(p->targ[0]));
			break;
		case STX:
			printf("stx(%s{%d,%d}, %d, %d)", (p->varg)->text,
				(p->varg)->deflev, (p->varg)->defblk,
				ttoi(p->targ[0]), ttoi(p->targ[1]));
			break;
		case LAB:
			printf("lab(%d)", p->larg[0]);
			break;
		case SEL:
			printf("sel(%d, %d, %d)", ttoi(p->targ[0]),
				p->larg[0], p->larg[1]);
			break;
		case KILL:
			printf("kill(%s{%d,%d})", (p->varg)->text,
				(p->varg)->deflev, (p->varg)->defblk);
			break;
		default:
			printf("{bad opcode %d}", p->oarg);
		}

		printf("\n");
		p = p->next;
	}
}

static void
cgbin(s, p)
char *s;
tuple *p;
{
	printf("%s(%d, %d)", s, ttoi(p->targ[0]), ttoi(p->targ[1]));
}

static int
ttoi(t)
register tuple *t;
{
	/* tuple pointer to int position */
	register int i = 0;
	register tuple *p = code.next;

	while (p != &code) {
		if (p == t) return(i);
		++i;
		p = p->next;
	}

	return(-1);
}

static tuple *
mktuple()
{
	/* make a tuple and link it into code */
	extern char *malloc();
	register tuple *p = ((tuple *) malloc(sizeof(tuple)));

	p->next = &code;
	(p->prev = code.prev)->next = p;
	return(code.prev = p);
}

static void
rmtuple(p)
register tuple *p;
{
	/* remove this tuple */

	(p->prev)->next = p->next;
	(p->next)->prev = p->prev;
	free((char *) p);
}
