#include <stdio.h>

#define	ITE	0
#define	X	1
#define	Y	2
#define	Z	3
#define	CONST0	4
#define	CONST1	5
#define	OPS	6

int	x, y, z;

int
ref(void)
{
	return(x & !z);
}


#define	LIMIT		1024
#define	POPSIZE		1024
#define	MAXNODES	(POPSIZE * LIMIT)

/*	Tree node structure...
*/
typedef struct _node {
	char	op, kids;
	int	value;
	int	kid[3];
} node;

node	n[MAXNODES];
int	freelist = 0;

void
freeall(void)
{
	register int i;

	/* Put all nodes on the freelist */
	for (i=0; i<MAXNODES; ++i) {
		n[i].kid[0] = i + 1;
	}
	freelist = 0;
}

int
mknode(void)
{
	register int root = freelist;

	if (root == (MAXNODES - 1)) {
		fprintf(stderr, "Out of tree node memory\n");
		exit(1);
	}
	freelist = n[root].kid[0];
	return(root);
}

void
freetree(register int root)
{
	register int i;

	for (i=0; i<n[root].kids; ++i) {
		freetree(n[root].kid[i]);
	}
	n[root].kid[0] = freelist;
	freelist = root;
}

int
eval(register int root)
{
	switch (n[root].op) {
	case ITE:
		if (eval(n[root].kid[0])) {
			return(eval(n[root].kid[1]));
		}
		return(eval(n[root].kid[2]));
	case X:
		return(x);
	case Y:
		return(y);
	case Z:
		return(z);
	case CONST0:
		return(0);
	case CONST1:
		return(1);
	}

	fprintf(stderr, "Illegal operation error in eval()\n");
	exit(1);
}

void
outtree(register int root)
{
	switch (n[root].op) {
	case ITE:
		printf("(");
		outtree(n[root].kid[0]);
		printf(" ? ");
		outtree(n[root].kid[1]);
		printf(" : ");
		outtree(n[root].kid[2]);
		printf(")");
		return;
	case X:
		printf("x");
		return;
	case Y:
		printf("y");
		return;
	case Z:
		printf("z");
		return;
	case CONST0:
		printf("0");
		return;
	case CONST1:
		printf("1");
		return;
	}

	fprintf(stderr, "Illegal operation error in outtree()\n");
	exit(1);
}
