#include "common.c"


typedef	struct _member {
	int	root;
	int	fitness;
} member;

member	m[POPSIZE+1];

int	limit, limitsave = (LIMIT - 1);
int	nodecount;

int
copytree(register int root)
{
	register int i;
	register int copy = mknode();

	n[copy] = n[root];
	for (i=0; i<n[copy].kids; ++i) {
		n[copy].kid[i] = copytree(n[copy].kid[i]);
	}
	return(copy);
}

void
countnodes2(register int root)
{
	register int i;

	++nodecount;

	for (i=0; i<n[root].kids; ++i) {
		countnodes(n[root].kid[i]);
	}
}

int
countnodes(register int root)
{
	nodecount = 0;
	countnodes2(root);
	return(nodecount);
}

int
findspot2(register int root)
{
	register int i;

	if (--nodecount <= 0) {
		return(root);
	}

	for (i=0; i<n[root].kids; ++i) {
		if (findspot2(n[root].kid[i]) != -1) {
			return(n[root].kid[i]);
		}
	}
	return(-1);
}

int
findspot(register int root,
register int spot)
{
	nodecount = spot;
	return(findspot2(root));
}

int
picknode(register int root)
{
	return(findspot(root, 1 + (rand() % countnodes(root))));
}

int
replace(register int master,
register int sub,
register int add)
{
	register int i;

	if (sub == master) {
		freetree(sub);
		return(add);
	}

	for (i=0; i<n[master].kids; ++i) {
		n[master].kid[i] = replace(n[master].kid[i], sub, add);
	}
	return(master);
}

int
randtree2(void)
{
	register int root = mknode();

again:
	switch (rand() % OPS) {
	case ITE:
		if (limit < 4) goto again;
		limit -= 4;
		n[root].op = ITE;
		n[root].kids = 3;
		n[root].kid[0] = randtree2();
		n[root].kid[1] = randtree2();
		n[root].kid[2] = randtree2();
		return(root);
	case X:
		--limit;
		n[root].op = X;
		n[root].kids = 0;
		return(root);
	case Y:
		--limit;
		n[root].op = Y;
		n[root].kids = 0;
		return(root);
	case Z:
		--limit;
		n[root].op = Z;
		n[root].kids = 0;
		return(root);
	case CONST0:
		--limit;
		n[root].op = CONST0;
		n[root].kids = 0;
		return(root);
	case CONST1:
		--limit;
		n[root].op = CONST1;
		n[root].kids = 0;
		return(root);
	}

	fprintf(stderr, "Illegal operation error in randtree2()\n");
	exit(1);
}

int
randtree(void)
{
	limit = limitsave;
	return(randtree2());
}

int
crossover(register int mom,
register int dad)
{
	register int baby = copytree(mom);
	register int momcut;
	register int dadcut;

	/* Pick cutpoints */
	do {
		momcut = picknode(baby);
		dadcut = picknode(dad);
	} while ((countnodes(baby) -
		  countnodes(momcut) +
		  countnodes(dad)) > limitsave);

	/* Splice new copy in */
	dadcut = copytree(dadcut);
	return(replace(baby, momcut, dadcut));
}

int
mutate(register int mom)
{
	register int baby = copytree(mom);
	register int momcut;
	register int dadcut;

	/* Pick mom cutpoint & create random dadcut */
	momcut = picknode(baby);
	limit = limitsave - (countnodes(baby) - countnodes(momcut));
	dadcut = randtree2();

	/* Splice it in */
	return(replace(baby, momcut, dadcut));
}


main(register int argc,
register char **argv)
{
	int pop, cross, mut, gens, gen = 0;
	int i, j, k;

	if (argc == 5) {
		pop = atoi(argv[1]);
		cross = atoi(argv[2]);
		mut = atoi(argv[3]);
		gens = atoi(argv[4]);
	} else {
		fprintf(stderr,
			"Usage: %s [pop] [cross] [mut] [gens]\n",
			argv[0]);
		exit(1);
	}

	srand(time(0));

	freeall();

	/* Create initial population */
	for (i=0; i<pop; ++i) {
		m[i].root = randtree();
	}

	for (;;) {
		/* Evaluate metric */
		for (i=0; i<pop; ++i) {
			m[i].fitness = 0;
			for (j=0; j<8; ++j) {
				x = (j & 1);
				y = ((j >> 1) & 1);
				z = ((j >> 2) & 1);
				if (ref() == eval(m[i].root)) {
					++(m[i].fitness);
				}
			}
		}

		/* Sort into decreasing metric value...
		   a lousy sort, but minimal swaps
		*/
		for (j=0; j<pop; ++j) {
			k = j;
			for (i=j+1; i<pop; ++i) {
				if (m[i].fitness >= m[k].fitness) {
					k = i;
				}
			}
			if (k != j) {
				member t = m[k];
				m[k] = m[j];
				m[j] = t;
			}
		}

		/* Print the stats & exit if solution found */
		printf("Generation %5d: %d..%d: ",
		       gen,
		       m[pop-1].fitness,
		       m[0].fitness);
		outtree(m[0].root);
		printf("\n");
		if ((++gen >= gens) || (m[0].fitness == 8)) {
			exit(0);
		}

		/* Replace bottom guys with crossovers */
		for (i=pop-cross; i<pop; ++i) {
			int a = (rand() % (pop-cross));
			int b = (rand() % (pop-cross));
			freetree(m[i].root);
			m[i].root = crossover(m[a].root, m[b].root);
		}

		/* Replace some more with mutants */
		for (i=pop-cross-mut; i<pop-cross; ++i) {
			int a = (rand() % (pop-cross));
			freetree(m[i].root);
			m[i].root = mutate(m[a].root);
		}
	}
}
