#include "common.c"


int	limit, limitsave = (LIMIT - 1);

int
randtree2(void)
{
	register int root = mknode();

again:
	switch (rand() % OPS) {
	case ITE:
		if (limit < 4) goto again;
		limit -= 4;
		n[root].op = ITE;
		n[root].kids = 3;
		n[root].kid[0] = randtree2();
		n[root].kid[1] = randtree2();
		n[root].kid[2] = randtree2();
		return(root);
	case X:
		--limit;
		n[root].op = X;
		n[root].kids = 0;
		return(root);
	case Y:
		--limit;
		n[root].op = Y;
		n[root].kids = 0;
		return(root);
	case Z:
		--limit;
		n[root].op = Z;
		n[root].kids = 0;
		return(root);
	case CONST0:
		--limit;
		n[root].op = CONST0;
		n[root].kids = 0;
		return(root);
	case CONST1:
		--limit;
		n[root].op = CONST1;
		n[root].kids = 0;
		return(root);
	}

	fprintf(stderr, "Illegal operation error in randtree2()\n");
	exit(1);
}

int
randtree(void)
{
	limit = limitsave;
	return(randtree2());
}

main(register int argc,
register char **argv)
{
	int i, j, r, best = -1, fitness, tries;

	if (argc == 2) {
		tries = atoi(argv[1]);
	} else {
		fprintf(stderr,
			"Usage: %s [tries]\n",
			argv[0]);
		exit(1);
	}

	srand(time(0));

	freeall();

	for (i=0; i<tries; ++i) {
		r = randtree();
		fitness = 0;
		for (j=0; j<8; ++j) {
			x = (j & 1);
			y = ((j >> 1) & 1);
			z = ((j >> 2) & 1);
			if (ref() == eval(r)) {
				++fitness;
			}
		}

		if (fitness > best) {
			best = fitness;
			printf("%5d: %d: ",
			       i,
			       fitness);
			outtree(r);
			printf("\n");
			if (fitness == 8) {
				exit(0);
			}
		}

		freetree(r);
	}
}
