#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/mman.h>

#define	MARGIN	16

typedef struct { int x, y; } offset_t;

extern unsigned char *
ppm_in(register int *x, register int *y, register char *filename);


/* START OF YOUR CODE... */

unsigned int
diff(register unsigned char *im1,
register unsigned char *im2,
register int x,
register int y,
register int dx,
register int dy)
{
	register int i, j, rgb;
	register unsigned int d = 0;

	for (j=MARGIN; j<(y-MARGIN); ++j) {
		for (i=MARGIN; i<(x-MARGIN); ++i) {
			register unsigned char *p = im1 + 3 * (i + (j * x));
			register unsigned char *q = im2 + 3 * (i + dx + ((j + dy) * x));

			for (rgb=0; rgb<3; ++rgb) {
				register int t = (*(p++) - *(q++));
				d += ((t > 0) ? t : -t);
			}
		}
	}
	return(d);
}



offset_t
bestoff(register unsigned char *im1,
register unsigned char *im2,
register int x,
register int y,
register int range)
{
	register int dx, dy, now;
	register offset_t bestd;
	register int best = diff(im1, im2, x, y, 0, 0);

	bestd.x = 0;
	bestd.y = 0;
	for (dy=(-range); dy<=range; ++dy) {
		for (dx=(-range); dx<=range; ++dx) {
			now = diff(im1, im2, x, y, dx, dy);
			if (now < best) {
				best = now;
				bestd.x = dx;
				bestd.y = dy;
			}
		}
	}
	return(bestd);
}

/* END OF YOUR CODE... */

main(int argc,
char **argv)
{
	int x1, y1, x2, y2;
	register unsigned char *im1, *im2;
	register offset_t bestd;

	if (argc != 3) {
		fprintf(stderr,
"Usage: %s image1.ppm image2.ppm\n",
			argv[0]);
		exit(1);
	}

	im1 = ppm_in(&x1, &y1, argv[1]);
	im2 = ppm_in(&x2, &y2, argv[2]);
	if ((x1 != x2) || (y1 != y2)) {
		fprintf(stderr,
"%s: images must be same size for alignment (%dx%d vs %dx%d)\n",
			argv[0],
			x1, y1,
			x2, y2);
		exit(1);
	}

	bestd = bestoff(im1, im2, x1, y1, (MARGIN-1));
	printf("bestdx=%d, bestdy=%d\n", bestd.x, bestd.y);

	exit(0);
}

unsigned char *
ppm_in(register int *x,
register int *y,
register char *filename)
{
	/* read a PPM file into an unsigned char array...
	   done by memory mapping the file
	*/
	register int fd;
	register int fsize;
	register unsigned char *map;
	register unsigned char *p;
	register int z;

	/* First, open the file... */
	if ((fd = open(filename, O_RDONLY)) < 0) {
		fprintf(stderr, "Error: cannot open file %s\n", filename);
		return(0);
	}

	/* Read size and map the whole file... */
	fsize = lseek(fd, ((off_t) 0), SEEK_END);
	map = ((unsigned char *)
	       mmap(0,		/* Put it anywhere */
		    fsize,	/* Map the whole file */
		    PROT_READ,	/* Read only */
		    MAP_SHARED,	/* Not just for me */
		    fd,		/* The file */
		    0));	/* Right from the start */
	if (((int) map) == -1) {
		close(fd);
		fprintf(stderr, "Error: cannot map file %s\n", filename);
		return(0);
	}

	/* File should now be mapped; read magic value */
	p = map;
	if ((*(p++) != 'P') || (*(p++) != '6')) {
		/* It isn't a P6 PPM file...
		*/
		fprintf(stderr, "Error: %s is not a P6 PPM file\n", filename);
		return(0);
	}

#define	Eat_Space \
	while ((*p == ' ') || \
	       (*p == '\t') || \
	       (*p == '\n') || \
	       (*p == '\r') || \
	       (*p == '#')) { \
		if (*p == '#') while (*(++p) != '\n') ; \
		++p; \
	}

	Eat_Space;		/* Eat white space and comments */

#define	Get_Number(n) \
	{ \
		register int charval = *p; \
 \
		if ((charval < '0') || (charval > '9')) goto ppm_exit; \
 \
		n = (charval - '0'); \
		charval = *(++p); \
		while ((charval >= '0') && (charval <= '9')) { \
			n *= 10; \
			n += (charval - '0'); \
			charval = *(++p); \
		} \
	}

	Get_Number(*x);	/* Get image width */

	Eat_Space;	/* Eat white space and comments */
	Get_Number(*y);	/* Get image width */

	Eat_Space;	/* Eat white space and comments */
	Get_Number(z);	/* Get image max value */

	/* Should be 8-bit binary after one whitespace char... */
	if (z > 255) {
ppm_exit:
		fprintf(stderr, "Error: cannot parse %s\n", filename);
		close(fd);
		munmap(map, fsize);
		return(0);
	}
	if ((*p != ' ') &&
	    (*p != '\t') &&
	    (*p != '\n') &&
	    (*p != '\r')) goto ppm_exit;

	/* Here we are... next byte begins the 8-bit data */
	return(p + 1);
}

#undef	Eat_Space
#undef	Get_Number

