#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/times.h>
#include <limits.h>
#include <time.h>

#include "common.h"

struct tms junk;
clock_t start, end, comptime;

int f (char DNA[])
{
	char substring[3] = {A, G, T};
	char count[LENGTH];
	int total;
	int i, j;

	/* start = times(&junk); */

	for (i=0; i<LENGTH-2; ++i) count[i] = 0;

	total = 0;

	for (i=0; i<3; ++i)
		for (j=0; j<LENGTH-2; ++j)
			count[j] += (DNA[j+i] == substring[i]);

	for (i=0; i<LENGTH-2; ++i)
		total += (count[i] == 3);

	/* end = times(&junk); */
	/* printf("Time elapsed for %d element check: %ld (%ld, %ld)\n",
		LENGTH, end-start, end, start);
	*/

	return total;
}

int main(void)
{
	int iters;
	int i;
	int total = 0;
	char DNA[LENGTH];

	#ifdef TIME_OVERALL
		start = times(&junk);
	#endif

	#ifdef TIME_COMPUTE
		comptime = 0ULL;
	#endif

	srand(SEED);
	for (iters=0; iters<ITERS; ++iters) {
		for (i=0; i<LENGTH; ++i) {
			DNA[i] = (char)(4.0*rand()/(RAND_MAX+1.0));
		}
		#ifdef DEBUG
			printf("DNA[i]=");
			for (i=LENGTH-1; i>=0; --i) {
				printf("%x ", DNA[i]);
			}
			printf("\n");
		#endif

		#ifdef TIME_COMPUTE
			start = times(&junk);
		#endif
		total += f(DNA);
		#ifdef TIME_COMPUTE
			end = times(&junk);
			comptime += (end-start);
		#endif
	}
	printf ("Total was %d.\n", total);

	#ifdef TIME_OVERALL
		end = times(&junk);
		printf("Time elapsed for %d element check: %ld (%ld, %ld)\n",
			LENGTH, end-start, end, start);
	#endif
	#ifdef TIME_COMPUTE
		printf("Time elapsed for %d element check: %ld\n",
			LENGTH, comptime);
	#endif

	return 0;
}

