${
$include <stdio.h>
$include <stdlib.h>
$include <time.h>
$include <sys/times.h>
$include <limits.h>
$include <time.h>
typedef unsigned long long int ullong;
$}

#include "common.h"

#if BPF == 128
	#define FRAGTYPE p128_t
	#define FRAGCTYPE ullong
	#define FRAGEXT uq
#elif BPF == 64
	#define FRAGTYPE p64_t
	#define FRAGCTYPE ullong
	#define FRAGEXT uq
	#define FRAGCONST ULL
#else
	#define FRAGTYPE p32_t
	#define FRAGCTYPE unsigned
	#define FRAGEXT ud
	#define FRAGCONST U
#endif

${
struct tms junk;
clock_t start, end, comptime;
$}

void f(unsigned int:2[LENGTH] DNA, unsigned int total)
{
	unsigned int:2[3] substring;
	unsigned int:2[LENGTH] count;
	unsigned int i;

#ifdef DEBUG_PEEK
	${
		static p128_t output;
		{
	$}
#endif
#ifdef DEBUG_TOTAL
	${
		printf("total=%u\n", *total);
	$}
#endif
#ifdef DEBUG_SUBSTRING
	${
		substring[0].uq[0] = 0x0123456789abcdefULL;
		substring[0].uq[1] = 0xfedcba9876543210ULL;
		printf("substring[0]={0x%016llx,0x%016llx}\n",
			substring[0].uq[0], substring[0].uq[1]);
	$}
#endif
	substring[0]=A; substring[1]=G; substring[2]=T;
#ifdef DEBUG_SUBSTRING
	${
		printf("substring[0]={0x%016llx,0x%016llx}\n",
			substring[0].uq[0], substring[0].uq[1]);
	$}
#endif
	count = 0;
#ifdef DEBUG_COUNT
	${
		int frag, x;
		for (frag=0; frag<((LENGTH/(BPF/2))+1); ++frag) {
			printf("count[%d]={0x%016llx,0x%016llx}\n",
				frag, count[frag].uq[0], count[frag].uq[1]);
		}
		for (x=0; x<((LENGTH/(BPF/2))+1); ++x)
			printf("  DNA[%d]={0x%016llx,0x%016llx}\n",
				x, DNA[x].uq[0], DNA[x].uq[1]);
	$}
#endif

	for (i=0; i<3; ++i) {
#ifdef DEBUG_COUNT
		${
			int x;

			printf("At top of loop: in memory order\n");
			for (x=0; x<((LENGTH/(BPF/2))+1); ++x)
				printf("count[%d]={0x%016llx,0x%016llx}\n",
					x, count[x].uq[0], count[x].uq[1]);
#ifdef DEBUG_SETCOUNTBYHAND
			printf("After setting by hand: in memory order\n");
			count[0].uq[0] = 0xffffffffffffffff;
			count[0].uq[1] = 0x0000000000000000;
			count[1].uq[0] = 0x0123456789abcdef;
			count[1].uq[1] = 0xfedcba9876543210;
			for (x=0; x<((LENGTH/(BPF/2))+1); ++x)
				printf("count[%d]={0x%016llx,0x%016llx}\n",
					x, count[x].uq[0], count[x].uq[1]);
#endif
		$}
#endif
		count = count[<< 1];
#ifdef DEBUG_COUNT
		${
			int x;

			printf("After shift: in memory order\n");
			for (x=0; x<((LENGTH/(BPF/2))+1); ++x)
				printf("count[%d]={0x%016llx,0x%016llx}\n",
					x, count[x].uq[0], count[x].uq[1]);
		$}
#endif
		count += (DNA == substring[i])? 1:0;
#ifdef DEBUG_COUNT
		${
			int x;

			printf("At bottom of loop: in memory order\n");
			for (x=0; x<((LENGTH/(BPF/2))+1); ++x)
				printf("count[%d]={0x%016llx,0x%016llx}\n",
					x, count[x].uq[0], count[x].uq[1]);
			printf("\n");
		$}
#endif
	}
#ifdef DEBUG_COUNT
	${
		int x;

		printf("Just outside loop: in memory order\n");
		for (x=0; x<((LENGTH/(BPF/2))+1); ++x)
			printf("count[%d]={0x%016llx,0x%016llx}\n",
				x, count[x].uq[0], count[x].uq[1]);
	$}
#endif

	count = (count == 3)? 1:0;
#ifdef DEBUG_COUNT
	${
		int x;

		printf("After marking full counts: in memory order\n");
		for (x=0; x<((LENGTH/(BPF/2))+1); ++x)
			printf("count[%d]={0x%016llx,0x%016llx}\n",
				x, count[x].uq[0], count[x].uq[1]);
	$}
#endif

	total += count;
#ifdef DEBUG_TOTAL
	${
		printf("total=%u\n", *total);
	$}
#endif
#ifdef DEBUG_PEEK
	${
		printf("output = {0x%016llx, 0x%016llx}\n",
			output.uq[0], output.uq[1]);
		}
	$}
#endif
}

${
int main(void)
{
	int iters, i, j, k;
	unsigned int total = 0;
	FRAGTYPE DNA[((2*LENGTH-1)/BPF)+1];

	#ifdef TIME_OVERALL
		start = times(&junk);
	#endif

	#ifdef TIME_COMPUTE
		comptime = 0ULL;
	#endif
	srand(SEED);

	for (iters=0; iters<ITERS; ++iters) {
		/* Full fragments - 32,31,...,0 */
		for (i=0; i<LENGTH/(BPF/2); ++i) {
			for (j=0; j<(BPF/2); ++j) {
			    #if BPF==128
			      DNA[i].FRAGEXT[0] = (DNA[i].FRAGEXT[0]>>2) |
				(DNA[i].FRAGEXT[1] << ((BPF/2)-2));
			      DNA[i].FRAGEXT[1] = (DNA[i].FRAGEXT[1]>>2) |
				( ((FRAGCTYPE)(4.0*rand()/(RAND_MAX+1.0))&0x3)
				  << 62 );
			    #else
			      DNA[i].FRAGEXT = (DNA[i].FRAGEXT>>2) |
				( ((FRAGCTYPE)(4.0*rand()/(RAND_MAX+1.0))&0x3)
				  << BPF-2 );
			    #endif
			}
		}

		/* Final, possibly partially-filled, fragment */
		if (i == (2*LENGTH-1)/BPF) {
			#if BPF==128
				DNA[i].FRAGEXT[1] = DNA[i].FRAGEXT[0] = 0ULL;
			#else
				DNA[i].FRAGEXT = 0ULL;
			#endif
		}
		for (j=0; j<LENGTH%(BPF/2); ++j) {
			#if BPF==128
			    if (LENGTH%(BPF/2) > 32) {
			      /* Store in upper half */
			      DNA[i].FRAGEXT[0] = (DNA[i].FRAGEXT[0]>>2) |
				(DNA[i].FRAGEXT[1] << ((BPF/2)-2));
			      DNA[i].FRAGEXT[1] = (DNA[i].FRAGEXT[1]>>2) |
				( ((FRAGCTYPE)(4.0*rand()/(RAND_MAX+1.0))&0x3)
				  << ((LENGTH%((BPF/2)/2))*2)-2);
			    } else {
			      /* Store in lower half */
			      DNA[i].FRAGEXT[1] = 0ULL;
			      DNA[i].FRAGEXT[0] = (DNA[i].FRAGEXT[0]>>2) |
				( ((FRAGCTYPE)(4.0*rand()/(RAND_MAX+1.0))&0x3)
				  << ((LENGTH%((BPF/2)/2))*2)-2);
			    }
			#else
			    DNA[i].FRAGEXT = (DNA[i].FRAGEXT>>2) |
				( ((FRAGCTYPE)(4.0*rand()/(RAND_MAX+1.0))&0x3)
				  << ((LENGTH%(BPF/2))*2)-2);
			#endif
		}

		#ifdef DEBUG
			printf("(Descending order) DNA[i]=");
			for (i=0; i<LENGTH; ++i) {
			    #if BPF==128
				j = (LENGTH-1-i)/(BPF/2);
				k = (LENGTH-1-i)%(BPF/2);
				if (k >= (BPF/4)) {
				  /* Field is in upper half */
				  k -= (BPF/4);
				  printf("%llu ",
					 (DNA[j].FRAGEXT[1]>>2*k) & 0x3ULL);
				} else {
				  /* Field is in lower half */
				  printf("%llu ",
					 (DNA[j].FRAGEXT[0]>>2*k) & 0x3ULL);
				}
			    #else
				j = (LENGTH-1-i)/(BPF/2);
				k = (LENGTH-1-i)%(BPF/2);
				printf("%d ",
				       (int)((DNA[j].FRAGEXT >> 2*k) &
					     0x3FRAGCONST));
			    #endif
			}
			printf("\n");
		#endif

		#ifdef TIME_COMPUTE
			start = times(&junk);
		#endif
		f(DNA, &total);
		#ifdef TIME_COMPUTE
			end = times(&junk);
			comptime += (end-start);
		#endif
	}
	printf ("Total was %u.\n", total);

	#ifdef TIME_OVERALL
		end = times(&junk);
		printf("Time elapsed for %d element check: %ld (%ld, %ld)\n",
			LENGTH, end-start, end, start);
	#endif
	#ifdef TIME_COMPUTE
		printf("Time elapsed for %d element check: %ld\n",
			LENGTH, comptime);
	#endif

	return 0;
}
$}

