/*	sample.Sc
*/

extern void print32(int c, int l);
extern void print16(short c, int l);
extern void print8(char c, int l);
extern void print32u(unsigned int c, int l);
extern void print16u(unsigned short c, int l);
extern void print8u(unsigned char c, int l);
extern void print4(char:4 c, int l);
extern void print2(char:2 c, int l);
extern void print1(char:1 c, int l);


char[16] a8, b8;

void
test1(int:1[64] a,
typeof(a) b)
{
	print1(a, widthof(a));
	print1(b, widthof(b));
${
	printf("ADD: ");
$}
	print1(a + b, widthof(a));
${
	printf("AND: ");
$}
	print1(a & b, widthof(a));
${
	printf("AVG: ");
$}
	print1(a +/ b, widthof(a));
${
	printf("DIV: ");
$}
	print1(a / b, widthof(a));
${
	printf("EQ: ");
$}
	print1(a == b, widthof(a));
${
	printf("GE: ");
$}
	print1(a >= b, widthof(a));
${
	printf("GT: ");
$}
	print1(a > b, widthof(a));
${
	printf("LAND: ");
$}
	print1(a && b, widthof(a));
${
	printf("LE: ");
$}
	print1(a <= b, widthof(a));
${
	printf("LOR: ");
$}
	print1(a || b, widthof(a));
${
	printf("LT: ");
$}
	print1(a < b, widthof(a));
${
	printf("MAX: ");
$}
	print1(a ?> b, widthof(a));
${
	printf("MIN: ");
$}
	print1(a ?< b, widthof(a));
${
	printf("MOD: ");
$}
	print1(a % b, widthof(a));
${
	printf("MUL: ");
$}
	print1(a * b, widthof(a));
${
	printf("NE: ");
$}
	print1(a != b, widthof(a));
${
	printf("OR: ");
$}
	print1(a | b, widthof(a));
${
	printf("SHL: ");
$}
	print1(a << 1, widthof(a));
${
	printf("SHR: ");
$}
	print1(a >> 1, widthof(a));
${
	printf("SUB: ");
$}
	print1(a - b, widthof(a));
${
	printf("XOR: ");
$}
	print1(a ^ b, widthof(a));
}

void
test2(int:2[32] a,
typeof(a) b)
{
	print2(a, widthof(a));
	print2(b, widthof(b));
${
	printf("ADD: ");
$}
	print2(a + b, widthof(a));
${
	printf("AND: ");
$}
	print2(a & b, widthof(a));
${
	printf("AVG: ");
$}
	print2(a +/ b, widthof(a));
${
	printf("DIV: ");
$}
	print2(a / b, widthof(a));
${
	printf("EQ: ");
$}
	print2(a == b, widthof(a));
${
	printf("GE: ");
$}
	print2(a >= b, widthof(a));
${
	printf("GT: ");
$}
	print2(a > b, widthof(a));
${
	printf("LAND: ");
$}
	print2(a && b, widthof(a));
${
	printf("LE: ");
$}
	print2(a <= b, widthof(a));
${
	printf("LOR: ");
$}
	print2(a || b, widthof(a));
${
	printf("LT: ");
$}
	print2(a < b, widthof(a));
${
	printf("MAX: ");
$}
	print2(a ?> b, widthof(a));
${
	printf("MIN: ");
$}
	print2(a ?< b, widthof(a));
${
	printf("MOD: ");
$}
	print2(a % b, widthof(a));
${
	printf("MUL: ");
$}
	print2(a * b, widthof(a));
${
	printf("NE: ");
$}
	print2(a != b, widthof(a));
${
	printf("OR: ");
$}
	print2(a | b, widthof(a));
${
	printf("SHL: ");
$}
	print2(a << 1, widthof(a));
${
	printf("SHR: ");
$}
	print2(a >> 1, widthof(a));
${
	printf("SUB: ");
$}
	print2(a - b, widthof(a));
${
	printf("XOR: ");
$}
	print2(a ^ b, widthof(a));
}

void
test4(int:4[16] a,
typeof(a) b)
{
	print4(a, widthof(a));
	print4(b, widthof(b));
${
	printf("ADD: ");
$}
	print4(a + b, widthof(a));
${
	printf("AND: ");
$}
	print4(a & b, widthof(a));
${
	printf("AVG: ");
$}
	print4(a +/ b, widthof(a));
${
	printf("DIV: ");
$}
	print4(a / b, widthof(a));
${
	printf("EQ: ");
$}
	print4(a == b, widthof(a));
${
	printf("GE: ");
$}
	print4(a >= b, widthof(a));
${
	printf("GT: ");
$}
	print4(a > b, widthof(a));
${
	printf("LAND: ");
$}
	print4(a && b, widthof(a));
${
	printf("LE: ");
$}
	print4(a <= b, widthof(a));
${
	printf("LOR: ");
$}
	print4(a || b, widthof(a));
${
	printf("LT: ");
$}
	print4(a < b, widthof(a));
${
	printf("MAX: ");
$}
	print4(a ?> b, widthof(a));
${
	printf("MIN: ");
$}
	print4(a ?< b, widthof(a));
${
	printf("MOD: ");
$}
	print4(a % b, widthof(a));
${
	printf("MUL: ");
$}
	print4(a * b, widthof(a));
${
	printf("NE: ");
$}
	print4(a != b, widthof(a));
${
	printf("OR: ");
$}
	print4(a | b, widthof(a));
${
	printf("SHL: ");
$}
	print4(a << 1, widthof(a));
${
	printf("SHR: ");
$}
	print4(a >> 1, widthof(a));
${
	printf("SUB: ");
$}
	print4(a - b, widthof(a));
${
	printf("XOR: ");
$}
	print4(a ^ b, widthof(a));
}

void
test8u(unsigned int:8[8] a,
typeof(a) b)
{
	print8u(a, widthof(a));
	print8u(b, widthof(b));
${
	printf("ADD: ");
$}
	print8u(a + b, widthof(a));
${
	printf("AND: ");
$}
	print8u(a & b, widthof(a));
${
	printf("AVG: ");
$}
	print8u(a +/ b, widthof(a));
${
	printf("DIV: ");
$}
	print8u(a / b, widthof(a));
${
	printf("EQ: ");
$}
	print8u(a == b, widthof(a));
${
	printf("GE: ");
$}
	print8u(a >= b, widthof(a));
${
	printf("GT: ");
$}
	print8u(a > b, widthof(a));
${
	printf("LAND: ");
$}
	print8u(a && b, widthof(a));
${
	printf("LE: ");
$}
	print8u(a <= b, widthof(a));
${
	printf("LOR: ");
$}
	print8u(a || b, widthof(a));
${
	printf("LT: ");
$}
	print8u(a < b, widthof(a));
${
	printf("MAX: ");
$}
	print8u(a ?> b, widthof(a));
${
	printf("MIN: ");
$}
	print8u(a ?< b, widthof(a));
${
	printf("MOD: ");
$}
	print8u(a % b, widthof(a));
${
	printf("MUL: ");
$}
	print8u(a * b, widthof(a));
${
	printf("NE: ");
$}
	print8u(a != b, widthof(a));
${
	printf("OR: ");
$}
	print8u(a | b, widthof(a));
${
	printf("SHL: ");
$}
	print8u(a << 1, widthof(a));
${
	printf("SHR: ");
$}
	print8u(a >> 1, widthof(a));
${
	printf("SUB: ");
$}
	print8u(a - b, widthof(a));
${
	printf("XOR: ");
$}
	print8u(a ^ b, widthof(a));
}

void
test16u(unsigned int:16[4] a,
typeof(a) b)
{
	print16u(a, widthof(a));
	print16u(b, widthof(b));
${
	printf("ADD: ");
$}
	print16u(a + b, widthof(a));
${
	printf("AND: ");
$}
	print16u(a & b, widthof(a));
${
	printf("AVG: ");
$}
	print16u(a +/ b, widthof(a));
${
	printf("DIV: ");
$}
	print16u(a / b, widthof(a));
${
	printf("EQ: ");
$}
	print16u(a == b, widthof(a));
${
	printf("GE: ");
$}
	print16u(a >= b, widthof(a));
${
	printf("GT: ");
$}
	print16u(a > b, widthof(a));
${
	printf("LAND: ");
$}
	print16u(a && b, widthof(a));
${
	printf("LE: ");
$}
	print16u(a <= b, widthof(a));
${
	printf("LOR: ");
$}
	print16u(a || b, widthof(a));
${
	printf("LT: ");
$}
	print16u(a < b, widthof(a));
${
	printf("MAX: ");
$}
	print16u(a ?> b, widthof(a));
${
	printf("MIN: ");
$}
	print16u(a ?< b, widthof(a));
${
	printf("MOD: ");
$}
	print16u(a % b, widthof(a));
${
	printf("MUL: ");
$}
	print16u(a * b, widthof(a));
${
	printf("NE: ");
$}
	print16u(a != b, widthof(a));
${
	printf("OR: ");
$}
	print16u(a | b, widthof(a));
${
	printf("SHL: ");
$}
	print16u(a << 1, widthof(a));
${
	printf("SHR: ");
$}
	print16u(a >> 1, widthof(a));
${
	printf("SUB: ");
$}
	print16u(a - b, widthof(a));
${
	printf("XOR: ");
$}
	print16u(a ^ b, widthof(a));
}

void
test32u(unsigned int:32[2] a,
typeof(a) b)
{
	print32u(a, widthof(a));
	print32u(b, widthof(b));
${
	printf("ADD: ");
$}
	print32u(a + b, widthof(a));
${
	printf("AND: ");
$}
	print32u(a & b, widthof(a));
${
	printf("AVG: ");
$}
	print32u(a +/ b, widthof(a));
${
	printf("DIV: ");
$}
	print32u(a / b, widthof(a));
${
	printf("EQ: ");
$}
	print32u(a == b, widthof(a));
${
	printf("GE: ");
$}
	print32u(a >= b, widthof(a));
${
	printf("GT: ");
$}
	print32u(a > b, widthof(a));
${
	printf("LAND: ");
$}
	print32u(a && b, widthof(a));
${
	printf("LE: ");
$}
	print32u(a <= b, widthof(a));
${
	printf("LOR: ");
$}
	print32u(a || b, widthof(a));
${
	printf("LT: ");
$}
	print32u(a < b, widthof(a));
${
	printf("MAX: ");
$}
	print32u(a ?> b, widthof(a));
${
	printf("MIN: ");
$}
	print32u(a ?< b, widthof(a));
${
	printf("MOD: ");
$}
	print32u(a % b, widthof(a));
${
	printf("MUL: ");
$}
	print32u(a * b, widthof(a));
${
	printf("NE: ");
$}
	print32u(a != b, widthof(a));
${
	printf("OR: ");
$}
	print32u(a | b, widthof(a));
${
	printf("SHL: ");
$}
	print32u(a << 1, widthof(a));
${
	printf("SHR: ");
$}
	print32u(a >> 1, widthof(a));
${
	printf("SUB: ");
$}
	print32u(a - b, widthof(a));
${
	printf("XOR: ");
$}
	print32u(a ^ b, widthof(a));
}

void
test8(int:8[8] a,
typeof(a) b)
{
	print8(a, widthof(a));
	print8(b, widthof(b));
${
	printf("ADD: ");
$}
	print8(a + b, widthof(a));
${
	printf("AND: ");
$}
	print8(a & b, widthof(a));
${
	printf("AVG: ");
$}
	print8(a +/ b, widthof(a));
${
	printf("DIV: ");
$}
	print8(a / b, widthof(a));
${
	printf("EQ: ");
$}
	print8(a == b, widthof(a));
${
	printf("GE: ");
$}
	print8(a >= b, widthof(a));
${
	printf("GT: ");
$}
	print8(a > b, widthof(a));
${
	printf("LAND: ");
$}
	print8(a && b, widthof(a));
${
	printf("LE: ");
$}
	print8(a <= b, widthof(a));
${
	printf("LOR: ");
$}
	print8(a || b, widthof(a));
${
	printf("LT: ");
$}
	print8(a < b, widthof(a));
${
	printf("MAX: ");
$}
	print8(a ?> b, widthof(a));
${
	printf("MIN: ");
$}
	print8(a ?< b, widthof(a));
${
	printf("MOD: ");
$}
	print8(a % b, widthof(a));
${
	printf("MUL: ");
$}
	print8(a * b, widthof(a));
${
	printf("NE: ");
$}
	print8(a != b, widthof(a));
${
	printf("OR: ");
$}
	print8(a | b, widthof(a));
${
	printf("SHL: ");
$}
	print8(a << 1, widthof(a));
${
	printf("SHR: ");
$}
	print8(a >> 1, widthof(a));
${
	printf("SUB: ");
$}
	print8(a - b, widthof(a));
${
	printf("XOR: ");
$}
	print8(a ^ b, widthof(a));
}

void
test16(int:16[4] a,
typeof(a) b)
{
	print16(a, widthof(a));
	print16(b, widthof(b));
${
	printf("ADD: ");
$}
	print16(a + b, widthof(a));
${
	printf("AND: ");
$}
	print16(a & b, widthof(a));
${
	printf("AVG: ");
$}
	print16(a +/ b, widthof(a));
${
	printf("DIV: ");
$}
	print16(a / b, widthof(a));
${
	printf("EQ: ");
$}
	print16(a == b, widthof(a));
${
	printf("GE: ");
$}
	print16(a >= b, widthof(a));
${
	printf("GT: ");
$}
	print16(a > b, widthof(a));
${
	printf("LAND: ");
$}
	print16(a && b, widthof(a));
${
	printf("LE: ");
$}
	print16(a <= b, widthof(a));
${
	printf("LOR: ");
$}
	print16(a || b, widthof(a));
${
	printf("LT: ");
$}
	print16(a < b, widthof(a));
${
	printf("MAX: ");
$}
	print16(a ?> b, widthof(a));
${
	printf("MIN: ");
$}
	print16(a ?< b, widthof(a));
${
	printf("MOD: ");
$}
	print16(a % b, widthof(a));
${
	printf("MUL: ");
$}
	print16(a * b, widthof(a));
${
	printf("NE: ");
$}
	print16(a != b, widthof(a));
${
	printf("OR: ");
$}
	print16(a | b, widthof(a));
${
	printf("SHL: ");
$}
	print16(a << 1, widthof(a));
${
	printf("SHR: ");
$}
	print16(a >> 1, widthof(a));
${
	printf("SUB: ");
$}
	print16(a - b, widthof(a));
${
	printf("XOR: ");
$}
	print16(a ^ b, widthof(a));
}

void
test32(int:32[2] a,
typeof(a) b)
{
	print32(a, widthof(a));
	print32(b, widthof(b));
${
	printf("ADD: ");
$}
	print32(a + b, widthof(a));
${
	printf("AND: ");
$}
	print32(a & b, widthof(a));
${
	printf("AVG: ");
$}
	print32(a +/ b, widthof(a));
${
	printf("DIV: ");
$}
	print32(a / b, widthof(a));
${
	printf("EQ: ");
$}
	print32(a == b, widthof(a));
${
	printf("GE: ");
$}
	print32(a >= b, widthof(a));
${
	printf("GT: ");
$}
	print32(a > b, widthof(a));
${
	printf("LAND: ");
$}
	print32(a && b, widthof(a));
${
	printf("LE: ");
$}
	print32(a <= b, widthof(a));
${
	printf("LOR: ");
$}
	print32(a || b, widthof(a));
${
	printf("LT: ");
$}
	print32(a < b, widthof(a));
${
	printf("MAX: ");
$}
	print32(a ?> b, widthof(a));
${
	printf("MIN: ");
$}
	print32(a ?< b, widthof(a));
${
	printf("MOD: ");
$}
	print32(a % b, widthof(a));
${
	printf("MUL: ");
$}
	print32(a * b, widthof(a));
${
	printf("NE: ");
$}
	print32(a != b, widthof(a));
${
	printf("OR: ");
$}
	print32(a | b, widthof(a));
${
	printf("SHL: ");
$}
	print32(a << 1, widthof(a));
${
	printf("SHR: ");
$}
	print32(a >> 1, widthof(a));
${
	printf("SUB: ");
$}
	print32(a - b, widthof(a));
${
	printf("XOR: ");
$}
	print32(a ^ b, widthof(a));
}


void
testcast(int:1[64] a)
{
	int:2[64] b;
	int:4[64] c;
	int:8[64] d;
	int:16[64] e;
	int:32[64] f;

${
	printf("int:1: ");
$}
	print1(a, widthof(a));
	b = a;
${
	printf("int:2: ");
$}
	print2(b, widthof(b));
	c = b;
${
	printf("int:4: ");
$}
	print4(c, widthof(c));
	d = c;
${
	printf("int:8: ");
$}
	print8(d, widthof(d));
	e = d;
${
	printf("int:16: ");
$}
	print16(e, widthof(e));
	f = e;
${
	printf("int:32: ");
$}
	print32(f, widthof(f));

	f = {1..widthof(f)};
${
	printf("int:32: ");
$}
	print32(f, widthof(f));
	e = f;
${
	printf("int:16: ");
$}
	print16(e, widthof(e));
	d = e;
${
	printf("int:8: ");
$}
	print8(d, widthof(d));
	c = d;
${
	printf("int:4: ");
$}
	print4(c, widthof(c));
	b = c;
${
	printf("int:2: ");
$}
	print2(b, widthof(b));
	a = b;
${
	printf("int:1: ");
$}
	print1(a, widthof(a));
}


${
int main(short argc, char **argv)
{
	register int i;

	switch (argc) {
	case 1: srand(time(0)); break;
	case 2: srand((unsigned int) strtoul(argv[1]), 0, 0); break;
	default: printf ("Usage: %s [seed]\n", argv[0]); exit (1);
	}

	for (i=0; i<8; ++i) {
		a8[i] = ((rand() / 255) & rand() & 255);
		b8[i] = ((rand() / 255) & rand() & 255);
	}
	printf("Testing 1-bit operations:\n");
	test1(a8, b8);

	for (i=0; i<8; ++i) {
		a8[i] = ((rand() / 255) & rand() & 255);
		b8[i] = ((rand() / 255) & rand() & 255);
	}
	printf("\nTesting 2-bit operations:\n");
	test2(a8, b8);

	for (i=0; i<8; ++i) {
		a8[i] = ((rand() / 255) & rand() & 255);
		b8[i] = ((rand() / 255) & rand() & 255);
	}
	printf("\nTesting 4-bit operations:\n");
	test4(a8, b8);

	for (i=0; i<8; ++i) {
		a8[i] = ((rand() / 255) & rand() & 255);
		b8[i] = ((rand() / 255) & rand() & 255);
	}
	printf("\nTesting 8-bit unsigned operations:\n");
	test8u(a8, b8);

	for (i=0; i<8; ++i) {
		a8[i] = ((rand() / 255) & rand() & 255);
		b8[i] = ((rand() / 255) & rand() & 255);
	}
	printf("\nTesting 16-bit unsigned operations:\n");
	test16u(a8, b8);

	for (i=0; i<8; ++i) {
		a8[i] = ((rand() / 255) & rand() & 255);
		b8[i] = ((rand() / 255) & rand() & 255);
	}
	printf("\nTesting 32-bit unsigned operations:\n");
	test32u(a8, b8);

	for (i=0; i<8; ++i) {
		a8[i] = ((rand() / 255) & rand() & 255);
		b8[i] = ((rand() / 255) & rand() & 255);
	}
	printf("\nTesting 8-bit operations:\n");
	test8(a8, b8);

	for (i=0; i<8; ++i) {
		a8[i] = ((rand() / 255) & rand() & 255);
		b8[i] = ((rand() / 255) & rand() & 255);
	}
	printf("\nTesting 16-bit operations:\n");
	test16(a8, b8);

	for (i=0; i<8; ++i) {
		a8[i] = ((rand() / 255) & rand() & 255);
		b8[i] = ((rand() / 255) & rand() & 255);
	}
	printf("\nTesting 32-bit operations:\n");
	test32(a8, b8);

	for (i=0; i<8; ++i) {
		a8[i] = ((rand() / 255) & rand() & 255);
		b8[i] = ((rand() / 255) & rand() & 255);
	}
	printf("\nTesting cast operations:\n");
	testcast(a8);
}
$}

${
void
print1(p64_t *vec,
int *len)
{
	register int i;
	register char *p = ((char *) vec);

	printf("{");
	for (i=*len-1; i>=0; --i) {
		register int j = p[i / 8];

		j = ((j >> (i & 7)) & 0x1);
		if (i > 0) {
			printf("%d, ", j);
		} else {
			printf("%d", j);
		}
	}
	printf("}\n");
}
$}

${
void
print2(p64_t *vec,
int *len)
{
	register int i;
	register char *p = ((char *) vec);

	printf("{");
	for (i=*len-1; i>=0; --i) {
		register int j = p[i / 4];

		j = ((j >> ((i & 3) * 2)) & 0x3);
		if (i > 0) {
			printf("%d, ", j);
		} else {
			printf("%d", j);
		}
	}
	printf("}\n");
}
$}

${
void
print4(p64_t *vec,
int *len)
{
	register int i;
	register char *p = ((char *) vec);

	printf("{");
	for (i=*len-1; i>=0; --i) {
		register int j = p[i / 2];

		j = (((i & 1) ? (j >> 4) : j) & 0xf);
		if (i > 0) {
			printf("%d, ", j);
		} else {
			printf("%d", j);
		}
	}
	printf("}\n");
}
$}

${
void
print8u(unsigned char *vec,
int *len)
{
	register int i;

	printf("{");
	for (i=*len-1; i>=0; --i) {
		if (i > 0) {
			printf("%u, ", vec[i]);
		} else {
			printf("%u", vec[i]);
		}
	}
	printf("}\n");
}
$}

${
void
print16u(unsigned short *vec,
int *len)
{
	register int i;

	printf("{");
	for (i=*len-1; i>=0; --i) {
		if (i > 0) {
			printf("%u, ", vec[i]);
		} else {
			printf("%u", vec[i]);
		}
	}
	printf("}\n");
}
$}

${
void
print32u(unsigned int *vec,
int *len)
{
	register int i;

	printf("{");
	for (i=*len-1; i>=0; --i) {
		if (i > 0) {
			printf("%u, ", vec[i]);
		} else {
			printf("%u", vec[i]);
		}
	}
	printf("}\n");
}
$}

${
void
print8(char *vec,
int *len)
{
	register int i;

	printf("{");
	for (i=*len-1; i>=0; --i) {
		if (i > 0) {
			printf("%d, ", vec[i]);
		} else {
			printf("%d", vec[i]);
		}
	}
	printf("}\n");
}
$}

${
void
print16(short *vec,
int *len)
{
	register int i;

	printf("{");
	for (i=*len-1; i>=0; --i) {
		if (i > 0) {
			printf("%d, ", vec[i]);
		} else {
			printf("%d", vec[i]);
		}
	}
	printf("}\n");
}
$}

${
void
print32(int *vec,
int *len)
{
	register int i;

	printf("{");
	for (i=*len-1; i>=0; --i) {
		if (i > 0) {
			printf("%d, ", vec[i]);
		} else {
			printf("%d", vec[i]);
		}
	}
	printf("}\n");
}
$}
