/* stdswar.h ******************************************************************
 Coding History:
	06-07-99 R.Fisher	Derived from stdswar.c
	06-08-99 R.Fisher	Added some cvt* functions
******************************************************************************/

extern int isbasedigit(int c, int base);

extern p128_t strto128u(const char *nptr, char **endptr, int base);

#define strtoull(nptr, endptr, base)	(strto64u(nptr, endptr, base).uq)

extern p64_t strto64u(const char *nptr, char **endptr, int base);

extern p128_t cvt1x4uto1x128u(unsigned char src);
extern p128_t cvt1x8uto1x128u(unsigned char src);
extern p128_t cvt1x16uto1x128u(unsigned int src);
extern p128_t cvt1x32uto1x128u(p32_t src);
extern p128_t cvt1x64uto1x128u(p64_t src);

extern p128_t cvt1x4uto32x4u(unsigned char src);
extern p128_t cvt1x8uto16x8u(unsigned char src);
extern p128_t cvt1x16uto8x16u(unsigned int src);
extern p128_t cvt1x32uto4x32u(p32_t src);
extern p128_t cvt1x64uto2x64u(p64_t src);

extern p64_t cvt1x4uto1x64u(unsigned char src);
extern p64_t cvt1x8uto1x64u(unsigned char src);
extern p64_t cvt1x16uto1x64u(unsigned int src);
extern p64_t cvt1x32uto1x64u(p32_t src);

extern p64_t cvt1x4uto16x4u(unsigned char src);
extern p64_t cvt1x8uto8x8u(unsigned char src);
extern p64_t cvt1x16uto4x16u(unsigned int src);
extern p64_t cvt1x32uto2x32u(p32_t src);

extern p32_t cvt1x4uto1x32u(unsigned char src);
extern p32_t cvt1x8uto1x32u(unsigned char src);
extern p32_t cvt1x16uto1x32u(unsigned int src);

extern p32_t cvt1x4uto8x4u(unsigned char src);
extern p32_t cvt1x8uto4x8u(unsigned char src);
extern p32_t cvt1x16uto2x16u(unsigned int src);

