/*
	3dnow.h

	MultiMedia eXtensions GCC interface library for AMD's
	3DNow! 32-bit floating-point enhancement of MMX.

	To use this library, simply include this header file and
	compile with GCC.  You must also include Sc.h BEFORE
	this file, since some defs there are used here.

	THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
	AND FITNESS FOR ANY PARTICULAR PURPOSE.

	April 1, 1999 by H. Dietz
	Addition of pavgusb, July 2, 2000 by R. Fisher
*/


/*	2x32 Parallel Float-to-Int
*/
#define	pf2id_m2r(var, reg)	mmx_m2r(pf2id, var, reg)
#define	pf2id_r2r(regs, regd)	mmx_r2r(pf2id, regs, regd)
#define	pf2id(vars, vard)	mmx_m2m(pf2id, vars, vard)

/*	2x32 Parallel Int-to-Float
*/
#define	pi2fd_m2r(var, reg)	mmx_m2r(pi2fd, var, reg)
#define	pi2fd_r2r(regs, regd)	mmx_r2r(pi2fd, regs, regd)
#define	pi2fd(vars, vard)	mmx_m2m(pi2fd, vars, vard)

/*	32-bit Float Reciprocal
*/
#define	pfrcp_r2r(regs, regd)	mmx_r2r(pfrcp, regs, regd)
#define	pfrcpit1_r2r(regs, regd)	mmx_r2r(pfrcpit1, regs, regd)
#define	pfrcpit2_r2r(regs, regd)	mmx_r2r(pfrcpit2, regs, regd)

/*	2x32 Parallel Float Add
*/
#define	pfadd_m2r(var, reg)	mmx_m2r(pfadd, var, reg)
#define	pfadd_r2r(regs, regd)	mmx_r2r(pfadd, regs, regd)
#define	pfadd(vars, vard)	mmx_m2m(pfadd, vars, vard)

/*	2x32 Parallel Float Compares
*/
#define	pfcmpeq_m2r(var, reg)	mmx_m2r(pfcmpeq, var, reg)
#define	pfcmpeq_r2r(regs, regd)	mmx_r2r(pfcmpeq, regs, regd)
#define	pfcmpeq(vars, vard)	mmx_m2m(pfcmpeq, vars, vard)

#define	pfcmpgt_m2r(var, reg)	mmx_m2r(pfcmpgt, var, reg)
#define	pfcmpgt_r2r(regs, regd)	mmx_r2r(pfcmpgt, regs, regd)
#define	pfcmpgt(vars, vard)	mmx_m2m(pfcmpgt, vars, vard)

#define	pfcmpge_m2r(var, reg)	mmx_m2r(pfcmpge, var, reg)
#define	pfcmpge_r2r(regs, regd)	mmx_r2r(pfcmpge, regs, regd)
#define	pfcmpge(vars, vard)	mmx_m2m(pfcmpge, vars, vard)

/*	2x32 Parallel Float Mul
*/
#define	pfmul_m2r(var, reg)	mmx_m2r(pfmul, var, reg)
#define	pfmul_r2r(regs, regd)	mmx_r2r(pfmul, regs, regd)
#define	pfmul(vars, vard)	mmx_m2m(pfmul, vars, vard)

/*	2x32 Parallel Float Sub
*/
#define	pfsub_m2r(var, reg)	mmx_m2r(pfsub, var, reg)
#define	pfsub_r2r(regs, regd)	mmx_r2r(pfsub, regs, regd)
#define	pfsub(vars, vard)	mmx_m2m(pfsub, vars, vard)

/*	2x32 Parallel Float Min and Max
*/
#define	pfmin_m2r(var, reg)	mmx_m2r(pfmin, var, reg)
#define	pfmin_r2r(regs, regd)	mmx_r2r(pfmin, regs, regd)
#define	pfmin(vars, vard)	mmx_m2m(pfmin, vars, vard)

#define	pfmax_m2r(var, reg)	mmx_m2r(pfmax, var, reg)
#define	pfmax_r2r(regs, regd)	mmx_r2r(pfmax, regs, regd)
#define	pfmax(vars, vard)	mmx_m2m(pfmax, vars, vard)

/*	Fast emms()
*/
#define	femms()			__asm__ __volatile__ ("femms")

/*	8x8u Average
*/
#define pavgusb_m2r(var, reg)	mmx_m2r(pavgusb, var, reg)
#define pavgusb_r2r(regs, regd)	mmx_r2r(pavgusb, regs, regd)
#define	pavgusb(vars, vard)	mmx_m2m(pavgusb, vars, vard)

