/*
	athlon.h

	MultiMedia eXtensions GCC interface library for AMD's
	3DNow! 32-bit floating-point enhancement of MMX.

	To use this library, simply include this header file and
	compile with GCC.  You must also include Sc.h BEFORE
	this file, since some defs there are used here.

	THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
	AND FITNESS FOR ANY PARTICULAR PURPOSE.

	November 8, 1999 by R. Fisher
*/


/* Templates */
#define	mmx_r2r_i(op, immed, regs, regd) \
	__asm__ __volatile__ (#op " $" #immed ", %" #regs ", %" #regd)



/*	2x32 Parallel Float-to-Int
*/
#define	pf2iw_m2r(var, reg)	mmx_m2r(pf2iw, var, reg)
#define	pf2iw_r2r(regs, regd)	mmx_r2r(pf2iw, regs, regd)

/*	2x32 Parallel Int-to-Float
*/
#define	pi2fw_m2r(var, reg)	mmx_m2r(pi2fw, var, reg)
#define	pi2fw_r2r(regs, regd)	mmx_r2r(pi2fw, regs, regd)

/*	4x16 Unsigned Parallel Mul High
*/
#define	pmulhuw_m2r(var, reg)	mmx_m2r(pmulhuw, var, reg)
#define	pmulhuw_r2r(regs, regd)	mmx_r2r(pmulhuw, regs, regd)

/*	8x8 Parallel Min and Max Unsigned
*/
#define	pminub_m2r(var, reg)	mmx_m2r(pminub, var, reg)
#define	pminub_r2r(regs, regd)	mmx_r2r(pminub, regs, regd)

#define	pmaxub_m2r(var, reg)	mmx_m2r(pmaxub, var, reg)
#define	pmaxub_r2r(regs, regd)	mmx_r2r(pmaxub, regs, regd)

/*	4x16 Parallel Min and Max Signed
*/
#define	pminsw_m2r(var, reg)	mmx_m2r(pminsw, var, reg)
#define	pminsw_r2r(regs, regd)	mmx_r2r(pminsw, regs, regd)

#define	pmaxsw_m2r(var, reg)	mmx_m2r(pmaxsw, var, reg)
#define	pmaxsw_r2r(regs, regd)	mmx_r2r(pmaxsw, regs, regd)

/*	8x8 Unsigned Parallel AVeraGe
*/
#define	pavgb_m2r(var, reg)	mmx_m2r(pavgb, var, reg)
#define	pavgb_r2r(regs, regd)	mmx_r2r(pavgb, regs, regd)

/*	4x16 Unsigned Parallel AVeraGe
*/
#define	pavgw_m2r(var, reg)	mmx_m2r(pavgw, var, reg)
#define	pavgw_r2r(regs, regd)	mmx_r2r(pavgw, regs, regd)

/*	4x16 Parallel SHUFfle
*/
#define	pshufw_i2r(imm, reg)	mmx_r2r_i(pshufw, imm, reg, reg)
