/*	swartypes.h

	Definitions for SWAR types on various architectures
*/

typedef union {
	signed int		d;	/* Doubleword (32-bit) value */
	unsigned int		ud;	/* Unsigned Doubleword */
	signed short		w[2];	/* 2 Word (16-bit) values */
	unsigned short		uw[2];	/* 2 Unsigned Word */
	signed char		b[4];	/* 4 Byte (8-bit) values */
	unsigned char		ub[4];	/* 4 Unsigned Byte */
	float			sf;	/* 1 Single-prec. (32-bit) FP value */
} __attribute__ ((aligned (4))) p32_t;

typedef	union {
	signed long long	q;	/* Quadword (64-bit) value */
	unsigned long long	uq;	/* Unsigned Quadword */
	signed int		d[2];	/* 2 Doubleword (32-bit) values */
	unsigned int		ud[2];	/* 2 Unsigned Doubleword */
	signed short		w[4];	/* 4 Word (16-bit) values */
	unsigned short		uw[4];	/* 4 Unsigned Word */
	signed char		b[8];	/* 8 Byte (8-bit) values */
	unsigned char		ub[8];	/* 8 Unsigned Byte */
	float			sf[2];	/* 2 Single-prec. (32-bit) FP values */
	double			df;	/* 1 Double-prec. (64-bit) FP value */
} __attribute__ ((aligned (8))) p64_t;

typedef union {
	signed long long	q[2];	/* Quadword (64-bit) value */
	unsigned long long	uq[2];	/* Unsigned Quadword */
	signed int		d[4];	/* 4 Doubleword (32-bit) values */
	unsigned int		ud[4];	/* 4 Unsigned Doubleword */
	signed short		w[8];	/* 8 Word (16-bit) values */
	unsigned short		uw[8];	/* 8 Unsigned Word */
	signed char		b[16];	/* 16 Byte (8-bit) values */
	unsigned char		ub[16];	/* 16 Unsigned Byte */
	float			sf[4];	/* 4 Single-prec. (32-bit) FP values */
	double			df[2];	/* 2 Double-prec. (64-bit) FP values */
} __attribute__ ((aligned (16))) p128_t;

