#include <stdio.h>
#include <swartypes.h>

int main(void)
{
	p128_t data;

	/* Ordering of 64-bit halves of p128_t in memory */
	printf ("&data.uq[0]=%p, &data.uq[1]=%p\n\n",
		&(data.uq[0]), &(data.uq[1]));
	/* Ordering of 8-bit sixteenths of p128_t in memory */
	printf ("&data.ub[0]=%p, &data.ub[1]=%p\n\n",
		&(data.ub[0]), &(data.ub[1]));

	/* 64-bit field identification */
	data.uq[1] = 0x1111111111111111ULL;
	data.uq[0] = 0ULL;
	printf ("data.uq[0,1]={0x%016llx,0x%016llx}\n", data.uq[0], data.uq[1]);
	printf ("uq[1] is filled with 1's\n");

	/* 64-bit field bit order identification */
	data.uq[1] = data.uq[0] = 0x1ULL;
	printf ("data.uq[0,1]={0x%016llx,0x%016llx}\n", data.uq[0], data.uq[1]);
	printf ("The low-order bit of each field is marked\n");

	data.uq[1] = data.uq[0] = 0x8000000000000000ULL;
	printf ("data.uq[0,1]={0x%016llx,0x%016llx}\n", data.uq[0], data.uq[1]);
	printf ("The high-order bit of each field is marked\n\n");


	/* 32-bit field identification */
	data.ud[3] = 0x33333333U;
	data.ud[2] = 0x22222222U;
	data.ud[1] = 0x11111111U;
	data.ud[0] = 0U;
	printf ("data.uq[0,1]={0x%016llx,0x%016llx}\n", data.uq[0], data.uq[1]);
	printf ("ud[i] is filled with i's\n");

	/* 32-bit field bit order identification */
	data.ud[3] = data.ud[2] = data.ud[1] = data.ud[0] = 0x1U;
	printf ("data.uq[0,1]={0x%016llx,0x%016llx}\n", data.uq[0], data.uq[1]);
	printf ("The low-order bit of each field is marked\n");

	data.ud[3] = data.ud[2] = data.ud[1] = data.ud[0] = 0x80000000U;
	printf ("data.uq[0,1]={0x%016llx,0x%016llx}\n", data.uq[0], data.uq[1]);
	printf ("The high-order bit of each field is marked\n\n");


	/* 16-bit field identification */
	data.uw[7] = 0x7777U;
	data.uw[6] = 0x6666U;
	data.uw[5] = 0x5555U;
	data.uw[4] = 0x4444U;
	data.uw[3] = 0x3333U;
	data.uw[2] = 0x2222U;
	data.uw[1] = 0x1111U;
	data.uw[0] = 0U;
	printf ("data.uq[0,1]={0x%016llx,0x%016llx}\n", data.uq[0], data.uq[1]);
	printf ("uw[i] is filled with i's\n");

	/* 16-bit field bit order identification */
	data.uw[7] = data.uw[6] = data.uw[5] = data.uw[4] =
	data.uw[3] = data.uw[2] = data.uw[1] = data.uw[0] = 0x1U;
	printf ("data.uq[0,1]={0x%016llx,0x%016llx}\n", data.uq[0], data.uq[1]);
	printf ("The low-order bit of each field is marked\n");

	data.uw[7] = data.uw[6] = data.uw[5] = data.uw[4] =
	data.uw[3] = data.uw[2] = data.uw[1] = data.uw[0] = 0x8000U;
	printf ("data.uq[0,1]={0x%016llx,0x%016llx}\n", data.uq[0], data.uq[1]);
	printf ("The high-order bit of each field is marked\n\n");


	/* 8-bit field identification */
	data.ub[15] = 0xffU;
	data.ub[14] = 0xeeU;
	data.ub[13] = 0xddU;
	data.ub[12] = 0xccU;
	data.ub[11] = 0xbbU;
	data.ub[10] = 0xaaU;
	data.ub[9] = 0x99U;
	data.ub[8] = 0x88U;
	data.ub[7] = 0x77U;
	data.ub[6] = 0x66U;
	data.ub[5] = 0x55U;
	data.ub[4] = 0x44U;
	data.ub[3] = 0x33U;
	data.ub[2] = 0x22U;
	data.ub[1] = 0x11U;
	data.ub[0] = 0U;
	printf ("data.uq[0,1]={0x%016llx,0x%016llx}\n", data.uq[0], data.uq[1]);
	printf ("ub[i] is filled with i's\n");

	/* 8-bit field bit order identification */
	data.ub[15] = data.ub[14] = data.ub[13] = data.ub[12] = 
	data.ub[11] = data.ub[10] = data.ub[9] = data.ub[8] =
	data.ub[7] = data.ub[6] = data.ub[5] = data.ub[4] =
	data.ub[3] = data.ub[2] = data.ub[1] = data.ub[0] = 0x1U;
	printf ("data.uq[0,1]={0x%016llx,0x%016llx}\n", data.uq[0], data.uq[1]);
	printf ("The low-order bit of each field is marked\n");

	data.ub[15] = data.ub[14] = data.ub[13] = data.ub[12] = 
	data.ub[11] = data.ub[10] = data.ub[9] = data.ub[8] =
	data.ub[7] = data.ub[6] = data.ub[5] = data.ub[4] =
	data.ub[3] = data.ub[2] = data.ub[1] = data.ub[0] = 0x80U;
	printf ("data.uq[0,1]={0x%016llx,0x%016llx}\n", data.uq[0], data.uq[1]);
	printf ("The high-order bit of each field is marked\n\n");

	return 0;
}

