/*	ir.h

	Internal Representation basic builder ops
*/


#define MAXNUMS 32768           /* vector constant pool */

extern int	numbuf[MAXNUMS];
extern int	numsp;

extern void
string2vnum(register char *p);

int wherestk[256];		/* what masking is in effect? */
int wheresp;

int breakstk[256];		/* where does break go? */
int breaksp;

int continuestk[256];		/* where does continue go? */
int continuesp;


extern char *
wheremask(register int lev);

extern int
newlabels(register int count);

extern void
zzcr_attr(Attrib *a, int tok, char *s);


extern typ typnull;		/* type is implied by use */
extern typ typconst;		/* ordinary int constant */
extern typ typfloat;		/* ordinary float constant */

extern typ typ1;
extern typ typ2;
extern typ typ4;
extern typ typ8;
extern typ typ16;
extern typ typ32;
extern typ typ64;
extern typ typ128;

extern typ typ1ss;
extern typ typ2ss;
extern typ typ4ss;
extern typ typ8ss;
extern typ typ16ss;
extern typ typ32ss;
extern typ typ64ss;
extern typ typ128ss;

extern typ typ1u;
extern typ typ2u;
extern typ typ4u;
extern typ typ8u;
extern typ typ16u;
extern typ typ32u;
extern typ typ64u;
extern typ typ128u;

extern typ typ1us;
extern typ typ2us;
extern typ typ4us;
extern typ typ8us;
extern typ typ16us;
extern typ typ32us;
extern typ typ64us;
extern typ typ128us;

extern typ typ32f;

extern tree *
mk_node(tree *down,
tree *right,
int op,
sym *symbol,
int num,
typ type);

extern tree *
mk_leaf(int op,
sym *symbol,
int num,
typ type);

extern tree *
mk_unary(int op,
tree *down);

extern tree *
mk_binary(int op,
tree *left,
tree *right);

extern tree *
mk_trinary(int op,
tree *one,
tree *two,
tree *twe);

extern tree *
mk_cast(typ type,
tree *down);

extern tree *
mk_type(typ type,
tree *down);

extern tree *
mk_cloned(tree *orig);

extern tree *
mk_clone(tree *t);

extern tree *
mk_nestwhere(tree *cond);

extern tree *
mk_elsewhere(void);

extern tree *
mk_loopwhere(void);

extern tree *
mk_assign(tree *dest,
tree *src);

extern tree *
mk_asop(int op,
int redop,
tree *dest,
tree *src);

extern tree *
mk_reduce(int op,
tree *down);

extern tree *
mk_newlabel(register int use,
register int num);

