/*	messages.c

	Warning, error, and bug message generating utilities
*/


#include <stdio.h>
#include "stdpccts.h"
#include "messages.h"

int errorcount = 0;
int warnlev = 0;        /* how much info? */


void
error(char *s)
{
	fprintf(stderr, "%s:%d: error: %s\n", sourcename, zzline, s);
	fflush(stderr);
	++errorcount;
}

void
bug(char *s)
{
	fprintf(stderr, "%s:%d: Scc bug: %s\n", sourcename, zzline, s);
	fflush(stderr);
	++errorcount;
}

void
warn(char *s)
{
	fprintf(stderr, "%s:%d: warning: %s\n", sourcename, zzline, s);
	fflush(stderr);
}

void
info(int level, char *s)
{
	if (warnlev >= level) {
		fprintf(stderr, "%s:%d: info: %s\n", sourcename, zzline, s);
		fflush(stderr);
	}
}

void
redeclared(sym *symbol)
{
	fprint_curr_function ( stderr );
	fprintf ( stderr, "%s:%d: redeclaration of `%s'\n",
		  sourcename, zzline, symbol->text );
	fprintf ( stderr, "%s:%d: `%s' previously declared here\n",
		  sourcename, symbol->decline, symbol->text );
	fflush(stderr);
	++errorcount;
}

void
duplabel(sym *symbol)
{
	fprint_curr_function ( stderr );
	fprintf ( stderr, "%s:%d: duplicate label `%s'\n",
		  sourcename, zzline, symbol->text );
	fprintf ( stderr, "%s:%d: `%s' previously used here\n",
		  sourcename, symbol->decline, symbol->text );
	fflush(stderr);
	++errorcount;
}



#undef NOTDEFD
#ifdef NOTDEFD
char *type2str ( int type )
{
	/* "undefined unsigned long long float single0" */
	static char str[42];

	if ( type & T_DEFINED )
		strcpy ( str, "defined " );
	else
		strcpy ( str, "undefined " );

	if ( type & T_UNSIGNED )
		strcat ( str, "unsigned " );
	else
		strcat ( str, "signed " );

	switch ( type & T_LENGTH )
	{
		case T_SHORT:
			strcat ( str, "short " );
			break;
		case T_NORMAL:
			strcat ( str, "normal " );
			break;
		case T_LONG:
			strcat ( str, "long " );
			break;
		case T_LONGLONG:
			strcat ( str, "long long " );
			break;
	}

	switch ( type & T_BASE )
	{
		case T_VOID:
			strcat ( str, "void " );
			break;
		case T_CHAR:
			strcat ( str, "char " );
			break;
		case T_INT:
			strcat ( str, "int " );
			break;
		case T_FLOAT:
			strcat ( str, "float " );
			break;
	}

	switch ( type & T_SIZE )
	{
		case T_VECTOR:
			strcat ( str, "vector" );
			break;
		case T_ARRAY:
			strcat ( str, "array" );
			break;
		default:
			strcat ( str, "single" );
	}

	return str;
}

/* Announce mismatch of types 'typea' and 'typeb' */
void mismatch ( int typea, int typeb )
{
	fprint_curr_function ( stderr );
	fprintf ( stderr, "%s:%d: incompatible types in assignment\n",
		  sourcename, zzline );
	fprintf ( stderr, "%s:%d:  (%4x) %s\n",
		  sourcename, zzline, typea, type2str(typea) );
	fprintf ( stderr, "%s:%d:  (%4x) %s\n",
		  sourcename, zzline, typeb, type2str(typeb) );
}
#endif


static fentry fnames[4096] = {{"At top level", 0}};
static int curr_function = 0;

/* Announce current function name (for debugging messages) */
void fprint_curr_function ( FILE *fp )
{
	if ( !fnames[curr_function].printed )
	{
		fnames[curr_function].printed = 1;
		if ( strcmp ( fnames[curr_function].name, "At top level" ) )
			fprintf ( fp, "%s: In function `%s':\n",
				  sourcename, fnames[curr_function].name );
		else
			fprintf ( fp, "%s: %s:\n",
				  sourcename, fnames[curr_function].name );
	}
}

/* Place a new function onto the function stack */
void fname_push ( char *newfunc )
{
	++curr_function;
	fnames[curr_function].name = malloc ( strlen(newfunc) + 1 );
	strcpy ( fnames[curr_function].name, newfunc );
	fnames[curr_function].printed = 0;
}

/* Remove a function from the function stack */
void fname_pop ( void )
{
	free ( fnames[curr_function--].name );
	fnames[curr_function].printed = 0;
}


void openfunction(void)
{
        /* Reset top of undeclared symtab */
}

void closefunction(void)
{
        /* Undo whatever openfunction() may have done */
}

