/*
	oputils.c

	These utilities provide information about the target architecture
*/

#include "stdpccts.h"
#include "swartypes.h"
#include "tuple.h"
#include "tokens.h"
#include "messages.h"

#undef DEBUG_FLDS_FRAG

int
commutative(int op)
{
	/* Returns 1 if op is commutative, 0 otherwise */

	switch (op) {
	/* These are commutative (non-ordered) */
	case ADD:
	case ADDH:
	case AVG:
	case EQ:
	case EQ_C:
	case AND:
	case LAND:
	case LOR:
	case MAX:
	case MIN:
	case MUL:
	case MULH:
	case MULEVEN:
	case MULODD:
	case NE:
	case NOR:
	case OR:
	case XOR:
		return(1);

	/* These are non-commutative (i.e. ordered) */
	case DIV:
	case GE:
	case GT:
	case GT_C:
	case ANDN:
	case LE:
	case LT:
	case MOD:
	case PUTGET:
	case ROTATE:
	case SHIFT:
	case SHL:
	case SHLBIT:
	case SHLBYTE:
	case SHR:
	case SHRBIT:
	case SHRBYTE:
	case SUB:
	case PACK:
	case PACKS2U:
	case INTRLVLOW:
	case INTRLVHIGH:
	case INTRLVEVEN:
	case INTRLVODD:
	case PERM:
	case TPERM:
	case REPL:
	case RCP1:
	case RCP2:
	case STORER:
	case STORERR:
	case STOREX:
		return(0);
	}

	/* Err on the FALSE side */
	return 0;
}

int
distributive(int op1, int op2)
{
	/* Returns 1 if op1 is distributive over op2, 0 otherwise */

	switch (op1) {
	case QUEST:
	case TPERM:
		return 0;

	case AND:
		switch (op2) {
		case AND:
		case ANDN:
		case OR:
			return 1;
		case NOR:
		default:
			return 0;
		}

	case ANDN:
		switch (op2) {
		case AND:
		case ANDN:
		case OR:
			return 1;
		case NOR:
		default:
			return 0;
		}

	case OR:
		switch (op2) {
		case AND:
		case OR:
			return 1;
		case ANDN:
		case NOR:
		default:
			return 0;
		}

	case NOR:
		switch (op2) {
			/* return 1; */
		case AND:
		case ANDN:
		case OR:
		case NOR:
		default:
			return 0;
		}

	case MUL:
		switch (op2) {
		case ADD:
		case SUB:
			return 1;
		default:
			return 0;
		}

	case MAX:
	case MIN:
		switch (op2) {
		case MAX:
		case MIN:
			return 1;
		default:
			return 0;
		}

	/* I'm not sure about these, so I'll assume they are not distributive
	   over anything for now. */
	case ADD:
	case ADDH:
	case AVG:
	case DIV:
	case MOD:
	case MULH:
	case MULEVEN:
	case MULODD:
	case SUB:

	case EQ:
	case EQ_C:
	case GE:
	case GT:
	case GT_C:
	case LE:
	case LT:
	case NE:

	case XOR:

	case LAND:
	case LOR:

	case PUTGET:
	case ROTATE:
	case SHIFT:
	case SHL:
	case SHLBIT:
	case SHLBYTE:
	case SHR:
	case SHRBIT:
	case SHRBYTE:
		return 0;

	/* I'm pretty sure about these */
	case PACK:
	case PACKS2U:
	case INTRLVLOW:
	case INTRLVHIGH:
	case INTRLVEVEN:
	case INTRLVODD:
	case PERM:
	case REPL:

	case RCP1:
	case RCP2:

	case STORER:
	case STORERR:
	case STOREX:

	case CAST:
	case LNOT:
	case NEG:
	case NOT:

	case UNPACKL:
	case UNPACKH:
	case RCP:
	case LEA:
	case LOADR:
	case LOADRR:
	case LOADX:
	case LVSL:
	case STORE:
	case I2F:
	case F2I:

	case NUM:
	case VNUM:
	case LOAD:
	case SIZEOF:

	case ALL:
	case ANY:
	case REDUCEADD:
	case REDUCEAND:
	case REDUCEAVG:
	case REDUCEMAX:
	case REDUCEMIN:
	case REDUCEMUL:
	case REDUCEOR:
	case REDUCEXOR:

	case BLOCK:
	case BREAK:
	case CALL:
	case CONTINUE:
	case DO:
	case EVERYWHERE:
	case EXPR:
	case FOR:
	case GOTO:
	case IF:
	case LABEL:
	case RETURN:
	case SEMI:
	case WHERE:
	case WHILE:
	default:
		return 0;
	}
}


/* Table of associative operations
   (Err on the FALSE side)
*/
/* HEREHERE - This needs to be expanded for new instructions: MIX* PERM */
int assoc[72][72] = {
 { /* ADD    */
		1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* ALL    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* AND    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* ANY    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* AVG    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* BLOCK  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* BREAK  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* CALL   */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* CAST   */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* CONTIN */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* DIV    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* DO     */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* EQ     */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* EVWHER */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* EXPR   */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* FOR    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* GE     */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* GOTO   */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* GT     */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* IF     */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* LABEL  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* LAND   */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* LE     */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* LNOT   */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* LOAD   */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* LOADX  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* LOR    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* LT     */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* MAX    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* MIN    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* MOD    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* MUL    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* NE     */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* NEG    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* NOT    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* NUM    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* OR     */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* PUTGET */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* QUEST  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* R_ADD  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* R_AND  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* R_AVG  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* R_MAX  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* R_MIN  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* R_MUL  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* R_OR   */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* R_XOR  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* RETURN */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* ROTATE */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* SEMI   */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* SHIFT  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* SHL    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* SHR    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* SIZEOF */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* STORE  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* STOREX */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* SUB    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* VNUM   */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* WHERE  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* WHILE  */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* XOR    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* PACK   */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* UNPCKL */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* UNPCKL */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* ANDN   */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* MULH   */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* I2F    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* F2I    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* RCP    */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* RCP1   */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
 { /* RCP2   */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
};

int
associative(int op1, int op2)
{
	/* Returns 1 if op1 is associative with op2, 0 otherwise */

	if ( (op1<ADD) || (op1>RCP2) || (op2<ADD) || (op2>RCP2) ) {
		return 0;
	}

	return (assoc[op1-122][op2-122]);
}

int
ordered(int op)
{
	/* Returns true if op is sensitive to operand order */

	switch (op) {
	case ANDN:
	case DIV:
	case GE:
	case GT:
	case GT_C:
	case INTRLVLOW:
	case INTRLVHIGH:
	case INTRLVEVEN:
	case INTRLVODD:
	case LE:
	case LT:
	case MOD:
	case PACK:
	case PACKS2U:
	case PERM:
	case TPERM:
	case RCP1:
	case RCP2:
	case REPL:
	case SHL:
	case SHLBIT:
	case SHLBYTE:
	case SHR:
	case SHRBIT:
	case SHRBYTE:
	case SUB:
	case UNPACKL:
	case UNPACKH:
		return(1);
	}

	return(0);
}



static int
ia32_bits(int bits)
{
	/* Return the largest number of bits that has the same number of bits
	   per fragment as "bits" would have on an IA32 */
	if (bits == 0) return(32);
	if (bits == 1) return(1);	/* 32 */
	if (bits == 2) return(2);	/* 16 */
	if (bits == 3) return(3);	/* 10 */
	if (bits == 4) return(4);	/* 8 */
	if (bits == 5) return(5);	/* 6 */
	if (bits == 6) return(6);	/* 5 */
	if (bits <= 8) return(8);	/* 4 */
	if (bits <= 10) return(10);	/* 3 */
	if (bits <= 16) return(16);	/* 2 */
	return(32);
}

int
mmx_bits(int bits)
{
	/* Return smallest supported field width that is
	   large enough to hold bits bits on MMX */
	if (bits == 0) return(64);
	if (bits == 1) return(1);
	if (bits == 2) return(2);
	if (bits <= 4) return(4);
	if (bits <= 8) return(8);
	if (bits <= 16) return(16);
	if (bits <= 32) return(32);
	return(64);
}

static int
sse_bits(int bits)
{
	/* Return smallest supported field width that is
	   large enough to hold bits bits on SSE */
	if (bits == 0) return(128);
	if (bits == 1) return(1);
	if (bits == 2) return(2);
	if (bits <= 4) return(4);
	if (bits <= 8) return(8);
	if (bits <= 16) return(16);
	if (bits <= 32) return(32);
	if (bits <= 64) return(64);
	return(128);
}

static int
max_bits(int bits)
{
	/* Return smallest supported field width that is
	   large enough to hold bits bits on MAX */
	if (bits == 0) return(64);
	if (bits == 1) return(1);
	if (bits == 2) return(2);
	if (bits <= 4) return(4);
	if (bits <= 8) return(8);
	if (bits <= 16) return(16);
	if (bits <= 32) return(32);
	return(64);
}

static int
altivec_bits(int bits)
{
	/* Return the largest number of bits that has the same number of bits
	   per fragment as "bits" would have on a PowerPC with AltiVec */
	if (bits == 0) return(128);
	if (bits == 1) return(1);
	if (bits == 2) return(2);
	if (bits <= 4) return(4);
	if (bits <= 8) return(8);
	if (bits <= 16) return(16);
	if (bits <= 32) return(32);
	if (bits <= 64) return(64);
	return(128);
}


int
bitsperfield(int bits)
{
	/* Return smallest supported field width that is
	   large enough to hold bits bits */
	if (optcpu == GenericIA32)
		return (ia32_bits(bits));
	if (optcpu & CPU_SSE)
		return (sse_bits(bits));
	if (optcpu & CPU_MMX)
		return (mmx_bits(bits));
	if (optcpu & CPU_MAX)
		return (max_bits(bits));
	if (optcpu & CPU_AltiVec)
		return (altivec_bits(bits));
	bug ( "bitsperfield() reports cpu_type unknown" );
	return 0;
}



int
bitsperfrag(void)
{
	if ((optcpu & CPU_SSE) || (optcpu & CPU_AltiVec))
		return 128;
	if ((optcpu & CPU_MMX) || (optcpu & CPU_MAX))
		return 64;
	if (optcpu == GenericIA32)
		return 32;
	bug ( "bitsperfrag() reports cpu_type unknown" );
	return 0;
}



unsigned long long
fieldsperfrag(int bits)
{
	#ifdef DEBUG_FLDS_FRAG
		fprintf(stderr, "bits=%d, bpf=%d, fpf=%llu\n",
		bits,
		bitsperfrag(),
		(unsigned long long)(bitsperfrag()/bits));
	#endif
	return ((unsigned long long)(bitsperfrag()/bits));
}


int
ia32_size(typ t)
{
	/* Returns number of p32_t units (fragments) necessary to hold "t" */
	register int bits = ia32_bits(t.bits);

	return(((t.dim * bits) + 31) / 32);
}

int
mmx_size(typ t)
{
	/* Returns number of p64_t units (fragments) necessary to hold "t" */
	register int bits = mmx_bits(t.bits);

	return(((t.dim * bits) + 63) / 64);
}

int
sse_size(typ t)
{
	/* Returns number of p128_t units (fragments) necessary to hold "t" */
	register int bits = sse_bits(t.bits);

	return(((t.dim * bits) + 127) / 128);
}

int
max_size(typ t)
{
	/* Returns number of p64_t units (fragments) necessary to hold "t" */
	register int bits = max_bits(t.bits);

	return(((t.dim * bits) + 63) / 64);
}

int
altivec_size(typ t)
{
	/* Returns number of p128_t units (fragments) necessary to hold "t" */
	register int bits = altivec_bits(t.bits);

	return(((t.dim * bits) + 127) / 128);
}

int
enh_size(typ t)
{
	/* Returns number of fragments necessary to hold "t" */
	if ( optcpu & CPU_SSE )
		return(sse_size(t));
	else if ( optcpu & CPU_MMX )
		return(mmx_size(t));
	else if ( optcpu == GenericIA32 )
		return(ia32_size(t));
	else if ( optcpu & CPU_MAX )
		return(max_size(t));
	else if ( optcpu & CPU_AltiVec )
		return(altivec_size(t));

	bug("enh_size() reports unknown enhanced register set");
	return 0;
}



static p32_t
ia32_minval(typ t)
{
	/* Return a frag-sized vector of minimum (un)signed values */
	/* Zeros bits not in a field */

	if (t.attr & TYP_UNSIGN) {
		return((p32_t) 0x00000000);
	}

	/* Assumes fields are packed low with no spacers */
	/* I include every case because we may want to add spacers at some
	   point, and have them differ based on the field width.  I haven't
	   thought this through, so maybe this isn't useful. */
	switch (ia32_bits(t.bits)) {
	case 1:		return((p32_t) 0xffffffff);
	case 2:		return((p32_t) 0xaaaaaaaa);
	case 3:		return((p32_t) 0x24924924);
	case 4:		return((p32_t) 0x88888888);
	case 5:		return((p32_t) 0x21084210);
	case 6:		return((p32_t) 0x20820820);
	case 7:		return((p32_t) 0x08102040);
	case 8:		return((p32_t) 0x80808080);
	case 9:		return((p32_t) 0x04020100);
	case 10:	return((p32_t) 0x20080200);
	case 11:	return((p32_t) 0x00200400);
	case 12:	return((p32_t) 0x00800800);
	case 13:	return((p32_t) 0x02001000);
	case 14:	return((p32_t) 0x08002000);
	case 15:	return((p32_t) 0x20004000);
	case 16:	return((p32_t) 0x80008000);
	case 17:	return((p32_t) 0x00010000);
	case 18:	return((p32_t) 0x00020000);
	case 19:	return((p32_t) 0x00040000);
	case 20:	return((p32_t) 0x00080000);
	case 21:	return((p32_t) 0x00100000);
	case 22:	return((p32_t) 0x00200000);
	case 23:	return((p32_t) 0x00400000);
	case 24:	return((p32_t) 0x00800000);
	case 25:	return((p32_t) 0x01000000);
	case 26:	return((p32_t) 0x02000000);
	case 27:	return((p32_t) 0x04000000);
	case 28:	return((p32_t) 0x08000000);
	case 29:	return((p32_t) 0x10000000);
	case 30:	return((p32_t) 0x20000000);
	case 31:	return((p32_t) 0x40000000);
	case 32:	return((p32_t) 0x80000000);
	default:	return((p32_t) 0);
	}
}

static p64_t
mmx_minval(typ t)
{
	/* Return a frag-sized vector of minimum (un)signed values */
	/* Assumes signed one-bit values are 0 and -1 */

	if (t.attr & TYP_UNSIGN) {
		return((p64_t) 0x0000000000000000LL);
	}

	switch (mmx_bits(t.bits)) {
	case 1:		return((p64_t) 0xffffffffffffffffLL);
	case 2:		return((p64_t) 0xaaaaaaaaaaaaaaaaLL);
	case 4:		return((p64_t) 0x8888888888888888LL);
	case 8:		return((p64_t) 0x8080808080808080LL);
	case 16:	return((p64_t) 0x8000800080008000LL);
	}

	return((p64_t) 0x8000000080000000LL);
}

static p128_t
sse_minval(typ t)
{
	/* Return a frag-sized vector of minimum (un)signed values */

	p128_t rval;

	if (t.attr & TYP_UNSIGN) {
			rval.q[1] = 0x0000000000000000LL;
			rval.q[0] = 0x0000000000000000LL;
		return(rval);
	}

	switch (sse_bits(t.bits)) {
	case 1:		rval.q[1] = 0xffffffffffffffffLL;
			rval.q[0] = 0xffffffffffffffffLL;
			break;
	case 2:		rval.q[1] = 0xaaaaaaaaaaaaaaaaLL;
			rval.q[0] = 0xaaaaaaaaaaaaaaaaLL;
			break;
	case 4:		rval.q[1] = 0x8888888888888888LL;
			rval.q[0] = 0x8888888888888888LL;
			break;
	case 8:		rval.q[1] = 0x8080808080808080LL;
			rval.q[0] = 0x8080808080808080LL;
			break;
	case 16:	rval.q[1] = 0x8000800080008000LL;
			rval.q[0] = 0x8000800080008000LL;
			break;
	case 32:	rval.q[1] = 0x8000000080000000LL;
			rval.q[0] = 0x8000000080000000LL;
			break;
	case 64:	rval.q[1] = 0x8000000000000000LL;
			rval.q[0] = 0x8000000000000000LL;
	}

	return(rval);
}

static p64_t
max_minval(typ t)
{
	/* Return a frag-sized vector of minimum (un)signed values */
	/* Assumes signed one-bit values are 0 and -1 */

	if (t.attr & TYP_UNSIGN) {
		return((p64_t) 0x0000000000000000LL);
	}

	switch (max_bits(t.bits)) {
	case 1:		return((p64_t) 0xffffffffffffffffLL);
	case 2:		return((p64_t) 0xaaaaaaaaaaaaaaaaLL);
	case 4:		return((p64_t) 0x8888888888888888LL);
	case 8:		return((p64_t) 0x8080808080808080LL);
	case 16:	return((p64_t) 0x8000800080008000LL);
	}

	return((p64_t) 0x8000000080000000LL);
}

static p128_t
altivec_minval(typ t)
{
	/* Return a frag-sized vector of minimum (un)signed values */

	p128_t rval;

	if (t.attr & TYP_UNSIGN) {
			rval.q[1] = 0x0000000000000000LL;
			rval.q[0] = 0x0000000000000000LL;
		return(rval);
	}

	switch (sse_bits(t.bits)) {
	case 1:		rval.q[1] = 0xffffffffffffffffLL;
			rval.q[0] = 0xffffffffffffffffLL;
			break;
	case 2:		rval.q[1] = 0xaaaaaaaaaaaaaaaaLL;
			rval.q[0] = 0xaaaaaaaaaaaaaaaaLL;
			break;
	case 4:		rval.q[1] = 0x8888888888888888LL;
			rval.q[0] = 0x8888888888888888LL;
			break;
	case 8:		rval.q[1] = 0x8080808080808080LL;
			rval.q[0] = 0x8080808080808080LL;
			break;
	case 16:	rval.q[1] = 0x8000800080008000LL;
			rval.q[0] = 0x8000800080008000LL;
			break;
	case 32:	rval.q[1] = 0x8000000080000000LL;
			rval.q[0] = 0x8000000080000000LL;
			break;
	case 64:	rval.q[1] = 0x8000000000000000LL;
			rval.q[0] = 0x8000000000000000LL;
	}

	return(rval);
}

p128_t
target_minval(typ t)
{
	p128_t rval = {{0ULL, 0ULL}};

	if (optcpu & CPU_SSE) {
		return (sse_minval(t));
	} else if (optcpu & CPU_MMX) {
		rval.uq[0] = mmx_minval(t).uq;
	} else if (optcpu == GenericIA32) {
		rval.ud[0] = ia32_minval(t).ud;
	} else if (optcpu & CPU_MAX) {
		rval.uq[0] = max_minval(t).uq;
	} else if (optcpu & CPU_AltiVec) {
		return (altivec_minval(t));
	}

	return (rval);
}



static p32_t
ia32_maxval(typ t)
{
	/* Return a frag-sized vector of maximum (un)signed values */
	/* Assumes signed one-bit values are 0 and -1 */
	/* Zeros bits not in a field */

	/* Unsigned */
	if (t.attr & TYP_UNSIGN) {
		return((p32_t) 0xffffffff);
	}

	/* Assumes fields are packed low with no spacers */
	switch (ia32_bits(t.bits)) {
	case 1:		return((p32_t) 0x00000000);
	case 2:		return((p32_t) 0x55555555);
	case 3:		return((p32_t) 0x1b6db6db);
	case 4:		return((p32_t) 0x77777777);
	case 5:		return((p32_t) 0x1ef7bdef);
	case 6:		return((p32_t) 0x1f7df7df);
	case 7:		return((p32_t) 0x07efdfbf);
	case 8:		return((p32_t) 0x7f7f7f7f);
	case 9:		return((p32_t) 0x03fdfeff);
	case 10:	return((p32_t) 0x1ff7fdff);
	case 11:	return((p32_t) 0x001ffbff);
	case 12:	return((p32_t) 0x007ff7ff);
	case 13:	return((p32_t) 0x01ffefff);
	case 14:	return((p32_t) 0x07ffdfff);
	case 15:	return((p32_t) 0x1fffbfff);
	case 16:	return((p32_t) 0x7fff7fff);
	case 17:	return((p32_t) 0x0000ffff);
	case 18:	return((p32_t) 0x0001ffff);
	case 19:	return((p32_t) 0x0003ffff);
	case 20:	return((p32_t) 0x0007ffff);
	case 21:	return((p32_t) 0x000fffff);
	case 22:	return((p32_t) 0x001fffff);
	case 23:	return((p32_t) 0x003fffff);
	case 24:	return((p32_t) 0x007fffff);
	case 25:	return((p32_t) 0x00ffffff);
	case 26:	return((p32_t) 0x01ffffff);
	case 27:	return((p32_t) 0x03ffffff);
	case 28:	return((p32_t) 0x07ffffff);
	case 29:	return((p32_t) 0x0fffffff);
	case 30:	return((p32_t) 0x1fffffff);
	case 31:	return((p32_t) 0x3fffffff);
	case 32:	return((p32_t) 0x7fffffff);
	}
	return (p32_t)0;
}

static p64_t
mmx_maxval(typ t)
{
	/* Return a frag-sized vector of maximum (un)signed values */
	/* Assumes signed one-bit values are 0 and -1 */

	/* Unsigned */
	if (t.attr & TYP_UNSIGN) {
		return((p64_t) 0xffffffffffffffffLL);
	}

	/* Signed */
	switch (mmx_bits(t.bits)) {
	case 1:		return((p64_t) 0x0000000000000000LL);
	case 2:		return((p64_t) 0x5555555555555555LL);
	case 4:		return((p64_t) 0x7777777777777777LL);
	case 8:		return((p64_t) 0x7f7f7f7f7f7f7f7fLL);
	case 16:	return((p64_t) 0x7fff7fff7fff7fffLL);
	}

	return((p64_t) 0x7fffffff7fffffffLL);
}

static p128_t
sse_maxval(typ t)
{
	/* Return a frag-sized vector of maximum (un)signed values */
	/* Assumes signed one-bit values are 0 and -1 */

	p128_t rval;

	/* Unsigned */
	if (t.attr & TYP_UNSIGN) {
		rval.q[1] = 0xffffffffffffffffLL;
		rval.q[0] = 0xffffffffffffffffLL;
		return(rval);
	}

	/* Signed */
	switch (sse_bits(t.bits)) {
	case 1:		rval.q[1] = 0x0000000000000000LL;
			rval.q[0] = 0x0000000000000000LL;
			break;
	case 2:		rval.q[1] = 0x5555555555555555LL;
			rval.q[0] = 0x5555555555555555LL;
			break;
	case 4:		rval.q[1] = 0x7777777777777777LL;
			rval.q[0] = 0x7777777777777777LL;
			break;
	case 8:		rval.q[1] = 0x7f7f7f7f7f7f7f7fLL;
			rval.q[0] = 0x7f7f7f7f7f7f7f7fLL;
			break;
	case 16:	rval.q[1] = 0x7fff7fff7fff7fffLL;
			rval.q[0] = 0x7fff7fff7fff7fffLL;
			break;
	case 32:	rval.q[1] = 0x7fffffff7fffffffLL;
			rval.q[0] = 0x7fffffff7fffffffLL;
			break;
	case 64:	rval.q[1] = 0x7fffffffffffffffLL;
			rval.q[0] = 0x7fffffffffffffffLL;
	}

	return(rval);
}

static p64_t
max_maxval(typ t)
{
	/* Return a frag-sized vector of maximum (un)signed values */
	/* Assumes signed one-bit values are 0 and -1 */

	/* Unsigned */
	if (t.attr & TYP_UNSIGN) {
		return((p64_t) 0xffffffffffffffffLL);
	}

	/* Signed */
	switch (max_bits(t.bits)) {
	case 1:		return((p64_t) 0x0000000000000000LL);
	case 2:		return((p64_t) 0x5555555555555555LL);
	case 4:		return((p64_t) 0x7777777777777777LL);
	case 8:		return((p64_t) 0x7f7f7f7f7f7f7f7fLL);
	case 16:	return((p64_t) 0x7fff7fff7fff7fffLL);
	}

	return((p64_t) 0x7fffffff7fffffffLL);
}

static p128_t
altivec_maxval(typ t)
{
	/* Return a frag-sized vector of maximum (un)signed values */
	/* Assumes signed one-bit values are 0 and -1 */

	p128_t rval;

	/* Unsigned */
	if (t.attr & TYP_UNSIGN) {
		rval.q[1] = 0xffffffffffffffffLL;
		rval.q[0] = 0xffffffffffffffffLL;
		return(rval);
	}

	/* Signed */
	switch (sse_bits(t.bits)) {
	case 1:		rval.q[1] = 0x0000000000000000LL;
			rval.q[0] = 0x0000000000000000LL;
			break;
	case 2:		rval.q[1] = 0x5555555555555555LL;
			rval.q[0] = 0x5555555555555555LL;
			break;
	case 4:		rval.q[1] = 0x7777777777777777LL;
			rval.q[0] = 0x7777777777777777LL;
			break;
	case 8:		rval.q[1] = 0x7f7f7f7f7f7f7f7fLL;
			rval.q[0] = 0x7f7f7f7f7f7f7f7fLL;
			break;
	case 16:	rval.q[1] = 0x7fff7fff7fff7fffLL;
			rval.q[0] = 0x7fff7fff7fff7fffLL;
			break;
	case 32:	rval.q[1] = 0x7fffffff7fffffffLL;
			rval.q[0] = 0x7fffffff7fffffffLL;
			break;
	case 64:	rval.q[1] = 0x7fffffffffffffffLL;
			rval.q[0] = 0x7fffffffffffffffLL;
	}

	return(rval);
}

p128_t
target_maxval(typ t)
{
	p128_t rval = {{0ULL, 0ULL}};

	if (optcpu & CPU_SSE) {
		return (sse_maxval(t));
	} else if (optcpu & CPU_MMX) {
		rval.uq[0] = mmx_maxval(t).uq;
	} else if (optcpu == GenericIA32) {
		rval.ud[0] = ia32_maxval(t).ud;
	} else if (optcpu & CPU_MAX) {
		rval.uq[0] = max_maxval(t).uq;
	} else if (optcpu & CPU_AltiVec) {
		return (altivec_maxval(t));
	}

	return (rval);
}



static p32_t
ia32_ONES(typ t)
{
	/* Return a frag-sized vector of unsigned 1 values */
	/* Zeros bits not in a field */

	/* Assumes fields are packed low with no spacers */
	switch (ia32_bits(t.bits)) {
	case 1:		return((p32_t) 0xffffffff);
	case 2:		return((p32_t) 0x55555555);
	case 3:		return((p32_t) 0x09249249);
	case 4:		return((p32_t) 0x11111111);
	case 5:		return((p32_t) 0x02108421);
	case 6:		return((p32_t) 0x01041041);
	case 7:		return((p32_t) 0x00204081);
	case 8:		return((p32_t) 0x01010101);
	case 9:		return((p32_t) 0x00040201);
	case 10:	return((p32_t) 0x00100401);
	case 11:	return((p32_t) 0x00000801);
	case 12:	return((p32_t) 0x00001001);
	case 13:	return((p32_t) 0x00002001);
	case 14:	return((p32_t) 0x00004001);
	case 15:	return((p32_t) 0x00008001);
	case 16:	return((p32_t) 0x00010001);
	case 17:	return((p32_t) 0x00000001);
	case 18:	return((p32_t) 0x00000001);
	case 19:	return((p32_t) 0x00000001);
	case 20:	return((p32_t) 0x00000001);
	case 21:	return((p32_t) 0x00000001);
	case 22:	return((p32_t) 0x00000001);
	case 23:	return((p32_t) 0x00000001);
	case 24:	return((p32_t) 0x00000001);
	case 25:	return((p32_t) 0x00000001);
	case 26:	return((p32_t) 0x00000001);
	case 27:	return((p32_t) 0x00000001);
	case 28:	return((p32_t) 0x00000001);
	case 29:	return((p32_t) 0x00000001);
	case 30:	return((p32_t) 0x00000001);
	case 31:	return((p32_t) 0x00000001);
	case 32:	return((p32_t) 0x00000001);
	}
	return (p32_t)0;
}

static p64_t
mmx_ONES(typ t)
{
	/* Return a frag-sized vector of unsigned 1 values */

	switch (mmx_bits(t.bits)) {
	case 1:		return((p64_t) 0xffffffffffffffffLL);
	case 2:		return((p64_t) 0x5555555555555555LL);
	case 4:		return((p64_t) 0x1111111111111111LL);
	case 8:		return((p64_t) 0x0101010101010101LL);
	case 16:	return((p64_t) 0x0001000100010001LL);
	}

	return((p64_t) 0x0000000100000001LL);
}

static p128_t
sse_ONES(typ t)
{
	/* Return a frag-sized vector of unsigned 1 values */

	p128_t rval;

	switch (sse_bits(t.bits)) {
	case 1:		rval.q[1] = 0xffffffffffffffffLL;
			rval.q[0] = 0xffffffffffffffffLL;
			break;
	case 2:		rval.q[1] = 0x5555555555555555LL;
			rval.q[0] = 0x5555555555555555LL;
			break;
	case 4:		rval.q[1] = 0x1111111111111111LL;
			rval.q[0] = 0x1111111111111111LL;
			break;
	case 8:		rval.q[1] = 0x0101010101010101LL;
			rval.q[0] = 0x0101010101010101LL;
			break;
	case 16:	rval.q[1] = 0x0001000100010001LL;
			rval.q[0] = 0x0001000100010001LL;
			break;
	case 32:	rval.q[1] = 0x0000000100000001LL;
			rval.q[0] = 0x0000000100000001LL;
			break;
	case 64:	rval.q[1] = 0x0000000000000001LL;
			rval.q[0] = 0x0000000000000001LL;
	}

	return(rval);
}

static p64_t
max_ONES(typ t)
{
	/* Return a frag-sized vector of unsigned 1 values */

	switch (max_bits(t.bits)) {
	case 1:		return((p64_t) 0xffffffffffffffffLL);
	case 2:		return((p64_t) 0x5555555555555555LL);
	case 4:		return((p64_t) 0x1111111111111111LL);
	case 8:		return((p64_t) 0x0101010101010101LL);
	case 16:	return((p64_t) 0x0001000100010001LL);
	}

	return((p64_t) 0x0000000100000001LL);
}

static p128_t
altivec_ONES(typ t)
{
	/* Return a frag-sized vector of unsigned 1 values */

	p128_t rval;

	switch (sse_bits(t.bits)) {
	case 1:		rval.q[1] = 0xffffffffffffffffLL;
			rval.q[0] = 0xffffffffffffffffLL;
			break;
	case 2:		rval.q[1] = 0x5555555555555555LL;
			rval.q[0] = 0x5555555555555555LL;
			break;
	case 4:		rval.q[1] = 0x1111111111111111LL;
			rval.q[0] = 0x1111111111111111LL;
			break;
	case 8:		rval.q[1] = 0x0101010101010101LL;
			rval.q[0] = 0x0101010101010101LL;
			break;
	case 16:	rval.q[1] = 0x0001000100010001LL;
			rval.q[0] = 0x0001000100010001LL;
			break;
	case 32:	rval.q[1] = 0x0000000100000001LL;
			rval.q[0] = 0x0000000100000001LL;
			break;
	case 64:	rval.q[1] = 0x0000000000000001LL;
			rval.q[0] = 0x0000000000000001LL;
	}

	return(rval);
}

p128_t
target_ONES(typ t)
{
	p128_t rval = {{0ULL, 0ULL}};

	if (optcpu & CPU_SSE) {
		return (sse_ONES(t));
	} else if (optcpu & CPU_MMX) {
		rval.uq[0] = mmx_ONES(t).uq;
	} else if (optcpu == GenericIA32) {
		rval.ud[0] = ia32_ONES(t).ud;
	} else if (optcpu & CPU_MAX) {
		rval.uq[0] = max_ONES(t).uq;
	} else if (optcpu & CPU_AltiVec) {
		return (altivec_ONES(t));
	}

	return (rval);
}


static p32_t
ia32_mask(typ t)
{
	/* Return bitmask of 1's covering fields in last p32_t unit.
	   Used to mask out the junk in the high-order bits of the last
	   fragment of a vector)
	*/
	register int bits = ia32_bits(t.bits);
	register int i = (((t.dim * bits) + 31) % 32);
	p32_t v;

	v.ud = (2ULL << i);
	--(v.ud);
	return(v);
}

static p64_t
mmx_mask(typ t)
{
	/* Return bitmask of 1's covering fields in last p64_t unit.
	   Used to mask out the junk in the high-order bits of the last
	   fragment of a vector)
	*/
	register int bits = mmx_bits(t.bits);
	register int i = (((t.dim * bits) + 63) % 64);
	p64_t v;

	v.uq = (2ULL << i);
	--(v.uq);
	return(v);
}

static p128_t
sse_mask(typ t)
{
	/* Return bitmask of 1's covering fields in last p128_t unit.
	   Used to mask out the junk in the high-order bits of the last
	   fragment of a vector)
	*/
	register int bits = sse_bits(t.bits);
	register unsigned long long i;
			 /* = highest bit position that is a '1' */
	p128_t v;

	i = (unsigned long long) (((t.dim * bits) + 127) % 128);

	/* If it extends into the higher quadword, then ALL the lower, realign
	   for the upper, and generate the partial mask for there.
	   If not, then ZERO the upper quadword, and generate the mask for the
	   lower.
	*/
	if (i>62ULL) {
		v.uq[1] = (1ULL << (i-63ULL));
		--(v.uq[1]);
		v.uq[0] = 0xffffffffffffffffULL;
	} else {
		v.uq[1] = 0x0000000000000000ULL;
		v.uq[0] = (2ULL << i);
		--(v.uq[0]);
	}

	return(v);
}

static p64_t
max_mask(typ t)
{
	/* Return bitmask of 1's covering fields in last p64_t unit.
	   Used to mask out the junk in the high-order bits of the last
	   fragment of a vector)
	*/
	register int bits = max_bits(t.bits);
	register int i = (((t.dim * bits) + 63) % 64);
	p64_t v;

	v.uq = (2ULL << i);
	--(v.uq);
	return(v);
}

static p128_t
altivec_mask(typ t)
{
	/* Return bitmask of 1's covering fields in last p128_t unit.
	   Used to mask out the junk in the high-order bits of the last
	   fragment of a vector)
	*/
	register int bits = altivec_bits(t.bits);
	register unsigned long long i;
			 /* = highest bit position that is a '1' */
	p128_t v;

	i = (unsigned long long) (((t.dim * bits) + 127) % 128);

	/* If it extends into the higher quadword, then ALL the lower, realign
	   for the upper, and generate the partial mask for there.
	   If not, then ZERO the upper quadword, and generate the mask for the
	   lower.
	*/
	if (i>62ULL) {
		v.uq[1] = (1ULL << (i-63ULL));
		--(v.uq[1]);
		v.uq[0] = 0xffffffffffffffffULL;
	} else {
		v.uq[1] = 0x0000000000000000ULL;
		v.uq[0] = (2ULL << i);
		--(v.uq[0]);
	}

	return(v);
}

p128_t
target_mask(typ t)
{
	p128_t lastmask;

	if (optcpu & CPU_SSE) {
		lastmask = sse_mask(t);
	} else if (optcpu & CPU_MMX) {
		lastmask.q[1] = 0LL;
		lastmask.q[0] = mmx_mask(t).q;
	} else if (optcpu == GenericIA32) {
		lastmask.q[1] = 0LL;
		lastmask.d[1] = 0;
		lastmask.d[0] = ia32_mask(t).d;
	} else if (optcpu & CPU_MAX) {
		lastmask.q[1] = 0LL;
		lastmask.q[0] = max_mask(t).q;
	} else if (optcpu & CPU_AltiVec) {
		lastmask = altivec_mask(t);
	} else {
		bug ( "target_mask() reports cpu_type unknown" );
	}
	return (lastmask);
}

unsigned int
target_field(unsigned int virtual_field,
unsigned int bitsperfrag)
{
	if (optcpu & CPU_AltiVec) {
		int d[4] = {3,2,1,0};
		int w[8] = {7,6,5,4,3,2,1,0};
		int b[16] = {15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0};

		switch (bitsperfrag) {
			case 8: return b[virtual_field];
			case 16: return w[virtual_field];
			case 32: return d[virtual_field];
			case 64: return (!virtual_field);
			default: return virtual_field;
		}
	} else {
		return virtual_field;
	}
}

