/*
	oputils.h

	These utilities provide information about the target architecture
*/

extern int commutative(int op);
extern int distributive(int op1, int op2);
extern int associative(int op1, int op2);
extern int ordered(int op);
extern int mmx_bits(int bits);
extern int bitsperfield(int bits);
extern int bitsperfrag(void);
extern unsigned long long fieldsperfrag(int bits);

extern int ia32_size(typ t);
extern int mmx_size(typ t);
extern int sse_size(typ t);
extern int enh_size(typ t);

extern p128_t target_minval(typ t);
extern p128_t target_maxval(typ t);
extern p128_t target_ONES(typ t);
extern p128_t target_mask(typ t);

extern unsigned int
target_field(unsigned int virtual_field, unsigned int bitsperfrag);

