/*
	output.c

	Functions for output formatting, etc.
*/

#include <stdio.h>
#include "swarc.h"
#include "output.h"

int Ctabpos = 1;		/* tabbing (for pretty-print output) */

void
Ctab(void)
{
	register int i = (4 * Ctabpos);

	while (i >= 8) { i-=8; fprintf(Cout, "\t"); }
	while (i > 0) { --i; fprintf(Cout, " "); }
}

/* Output #includes for this target's header files */
void headers(void)
{
		fprintf(Cout, "#include \"%s/swartypes.h\"\n", INCDIR);
		if (optcpu==GenericIA32) {
			fprintf(Cout, "#include \"%s/Scc_ia32.h\"\n", INCDIR);
		}
		if ( (optcpu & CPU_MMX) ) {
			fprintf(Cout, "#include \"%s/Scc_mmx.h\"\n", INCDIR);
		}
		if (optcpu & CPU_3DNow) {
			fprintf(Cout, "#include \"%s/Scc_3dnow.h\"\n", INCDIR);
		}
		if (optcpu & CPU_athlon) {
			fprintf(Cout, "#include \"%s/Scc_athlon.h\"\n", INCDIR);
		}
		if (optcpu & CPU_XMMX) {
			fprintf(Cout, "#include \"%s/Scc_xmmx.h\"\n", INCDIR);
		}
		if ( (optcpu & CPU_MAX) ) {
			fprintf(Cout, "#include \"%s/Scc_max.h\"\n", INCDIR);
		}
		if ( (optcpu & CPU_AltiVec) ) {
			fprintf(Cout,
				"#include \"%s/Scc_altivec.h\"\n",
				INCDIR);
		}
}

char *
argname(register int pos)
{
	/* name of argument pos in a call */
	static char argnamebuf[32];

	snprintf(&(argnamebuf[0]), 32, "_argument%d", pos);
	return(&(argnamebuf[0]));
}

