/*
	pseudoregs.c

	Support for generating code for targets using pseudo-register names,
	letting the C compiler do the actual scheduling.
*/ 

#include "stdpccts.h"
#include "swartypes.h"
#include "tuple.h"
#include "scheduler.h"
#include "spool.h"
#include "output.h"

int numspills;


static void
pseudoregsinit32(void)
{
	/* Declare the pseudo register names */
	/* This avoids spilling altogether */
	Ctab();
	fprintf(Cout, "register p32_t reg[%d];\n\n", regsavail()+maxspills());
}

void
pseudoregsinit(void)
{
	if (optcpu == GenericIA32)
		pseudoregsinit32();
}

