/*	showir.c

	Utilities for showing portions of the IR.

	These are NOT the code generation routines, but simply
	helpers for debugging.  (RJF: That isn't true, Hank IS using some of
	this for code generation.)
*/ 


#include "stdpccts.h"
#include "swartypes.h"
#include "oputils.h"
#include "showir.h"

/* This IS for code generation */
void
p_htype(typ *type)
{
	if ((type->attr & TYP_UNSIGN) &&
	    (type->attr & (TYP_CHAR | TYP_SHORT | TYP_INT |
			   TYP_LONG | TYP_LLONG))) {
		fprintf(Hout, "unsigned ");
	}
	if (type->attr & TYP_VOID) fprintf(Hout, "void ");
	if (type->attr & TYP_CHAR) fprintf(Hout, "char ");
	if (type->attr & TYP_SHORT) fprintf(Hout, "short ");
	if (type->attr & TYP_INT) fprintf(Hout, "int ");
	if (type->attr & TYP_LONG) fprintf(Hout, "long ");
	if (type->attr & TYP_LLONG) fprintf(Hout, "long long ");

	if (type->attr & TYP_FLOAT) {
		if (type->attr & TYP_SWAR) {
			fprintf(Hout, "p%d_t ", bitsperfrag());
		} else {
			fprintf(Hout, "float ");
		}
	} else if (type->attr & TYP_SWAR) {
		fprintf(Hout, "p%d_t ", bitsperfrag());
	}
}

void
p_hdim(typ *type)
{
	if (type->attr & TYP_SWAR) {
		fprintf(Hout, "[%d]", enh_size(*type));
	} else if (type->dim > 1) {
		fprintf(Hout, "[%d]", type->dim);
	}
}

/* This IS for code generation */
void
p_ctype(typ *type)
{
	if (type->attr & TYP_EXTERN) fprintf(Cout, "extern ");
	if (type->attr & TYP_STATIC) fprintf(Cout, "static ");
	if ((type->attr & TYP_UNSIGN) &&
	    (type->attr & (TYP_CHAR | TYP_SHORT | TYP_INT |
			   TYP_LONG | TYP_LLONG))) {
		fprintf(Cout, "unsigned ");
	}
	if (type->attr & TYP_VOID) fprintf(Cout, "void ");
	if (type->attr & TYP_CHAR) fprintf(Cout, "char ");
	if (type->attr & TYP_SHORT) fprintf(Cout, "short ");
	if (type->attr & TYP_INT) fprintf(Cout, "int ");
	if (type->attr & TYP_LONG) fprintf(Cout, "long ");
	if (type->attr & TYP_LLONG) fprintf(Cout, "long long ");
	if (type->attr & TYP_FLOAT) {
		if (type->attr & TYP_SWAR) {
			fprintf(Cout, "p%d_t ", bitsperfrag());
		} else {
			fprintf(Cout, "float ");
		}
	} else if (type->attr & TYP_SWAR) {
		fprintf(Cout, "p%d_t ", bitsperfrag());
	}
}

void
p_cdim(typ *type)
{
	if (type->attr & TYP_SWAR) {
		fprintf(Cout, "[%d]", enh_size(*type));
	} else if (type->dim > 1) {
		fprintf(Cout, "[%d]", type->dim);
	}
}

char *
opname (int opcode)
{
	static char buf[6];

	switch (opcode) {
	case CCODE:
		return ( "CCODE" );

	case ADD:
		return ( "ADD" );
	case ALL:
		return ( "ALL" );
	case AND:
		return ( "AND" );
	case ANY:
		return ( "ANY" );
	case AVG:
		return ( "AVG" );
	case BLOCK:
		return ( "BLOCK" );
	case BREAK:
		return ( "BREAK" );
	case CALL:
		return ( "CALL" );
	case CAST:
		return ( "CAST" );
	case CONTINUE:
		return ( "CONTINUE" );
	case DIV:
		return ( "DIV" );
	case DO:
		return ( "DO" );
	case EQ:
		return ( "EQ" );
	case EVERYWHERE:
		return ( "EVERYWHERE" );
	case EXPR:
		return ( "EXPR" );
	case FOR:
		return ( "FOR" );
	case GE:
		return ( "GE" );
	case GOTO:
		return ( "GOTO" );
	case GT:
		return ( "GT" );
	case IF:
		return ( "IF" );
	case LABEL:
		return ( "LABEL" );
	case LAND:
		return ( "LAND" );
	case LE:
		return ( "LE" );
	case LEA:
		return ( "LEA" );
	case LNOT:
		return ( "LNOT" );
	case LOAD:
		return ( "LOAD" );
	case LOADR:
		return ( "LOADR" );
	case LOADRR:
		return ( "LOADRR" );
	case LOADX:
		return ( "LOADX" );
	case LOR:
		return ( "LOR" );
	case LT:
		return ( "LT" );
	case LVSL:
		return ( "LVSL" );
	case MAX:
		return ( "MAX" );
	case MIN:
		return ( "MIN" );
	case MOD:
		return ( "MOD" );
	case MUL:
		return ( "MUL" );
	case NE:
		return ( "NE" );
	case NEG:
		return ( "NEG" );
	case NOT:
		return ( "NOT" );
	case NUM:
		return ( "NUM" );
	case OR:
		return ( "OR" );
	case PUTGET:
		return ( "PUTGET" );
	case QUEST:
		return ( "QUEST" );
	case REDUCEADD:
		return ( "REDUCEADD" );
	case REDUCEAND:
		return ( "REDUCEAND" );
	case REDUCEAVG:
		return ( "REDUCEAVG" );
	case REDUCEMAX:
		return ( "REDUCEMAX" );
	case REDUCEMIN:
		return ( "REDUCEMIN" );
	case REDUCEMUL:
		return ( "REDUCEMUL" );
	case REDUCEOR:
		return ( "REDUCEOR" );
	case REDUCEXOR:
		return ( "REDUCEXOR" );
	case REPL:
		return ( "REPL" );
	case RETURN:
		return ( "RETURN" );
	case ROTATE:
		return ( "ROTATE" );
	case SEMI:
		return ( "SEMI" );
	case SHIFT:
		return ( "SHIFT" );
	case SHL:
		return ( "SHL" );
	case SHLBIT:
		return ( "SHLBIT" );
	case SHLBYTE:
		return ( "SHLBYTE" );
	case SHR:
		return ( "SHR" );
	case SHRBIT:
		return ( "SHRBIT" );
	case SHRBYTE:
		return ( "SHRBYTE" );
	case SIZEOF:
		return ( "SIZEOF" );
	case STORE:
		return ( "STORE" );
	case STORER:
		return ( "STORER" );
	case STORERR:
		return ( "STORERR" );
	case STOREX:
		return ( "STOREX" );
	case SUB:
		return ( "SUB" );
	case VNUM:
		return ( "VNUM" );
	case WHERE:
		return ( "WHERE" );
	case WHILE:
		return ( "WHILE" );
	case XOR:
		return ( "XOR" );
	case PACK:
		return ( "PACK" );
	case UNPACKL:
		return ( "UNPACKL" );
	case UNPACKH:
		return ( "UNPACKH" );
	case INTRLVLOW:
		return ( "INTRLVLOW" );
	case INTRLVHIGH:
		return ( "INTRLVHIGH" );
	case ANDN:
		return ( "ANDN" );
	case MULH:
		return ( "MULH" );
	case MULEVEN:
		return ( "MULEVEN" );
	case MULODD:
		return ( "MULODD" );
	case I2F:
		return ( "I2F" );
	case F2I:
		return ( "F2I" );
	case RCP:
		return ( "RCP" );
	case RCP1:
		return ( "RCP1" );
	case RCP2:
		return ( "RCP2" );
	case INTRLVEVEN:
		return ( "INTRLVEVEN" );
	case INTRLVODD:
		return ( "INTRLVODD" );
	case PERM:
		return ( "PERM" );
	case TPERM:
		return ( "TPERM" );
	default:
		snprintf ( buf, 6, "%d", opcode );
		return ( buf );
	}
}

void
p_ir(tree *root, int order)
{
	/* Note: this does not show the elements of symbol->type */
	static int tab=0;
	register int i;

	if (!root) return;

	for ( i=tab; i; --i ) {
		printf ( " " );
	}
	printf ( "(%p %s num=%d atr=%d %dx%d ln=%d ",
		 root,
		 opname(root->op), root->num,
		 root->type.attr, root->type.dim, root->type.bits,
		 root->line
		 );

	if ( root->symbol ) {
		printf ( "\"%s\" scope=%d,%d)\n", root->symbol->text,
			 root->symbol->scope, root->symbol->serial);
	} else {
		printf ( "txt=N/A scope=N/A)\n" );
	}

	if (order == IR_DNRT) {
		if ( root->down ) {
			++tab;
			p_ir(root->down, order);
			--tab;
		}
		if ( root->right ) {
			p_ir(root->right, order);
		}
	} else {
		/* order == IR_RTDN */
		if ( root->right ) {
			++tab;
			p_ir(root->right, order);
			--tab;
		}
		if ( root->down ) {
			p_ir(root->down, order);
		}
	}

	/* I (rjf) don't really like the extra lines, so I place a ')' at
	   the end of the entry instead of at the end of it's subtree
	   (i.e. instead of doing this):
		for ( i=tab; i; --i ) {
			printf ( " " );
		}
		printf ( ")\n" );
	*/

	fflush (stdout);
}

#ifdef NOTYET
void
p_ir(tree *root, int order, int mode)
{
	/* Note: this does not show the elements of symbol->type */
	static int tab=0;
	register int i;

	if (!root) return;

	switch (mode)
	{
		case 0: /* human */
			for ( i=tab; i; --i ) {
				printf ( " " );
			}
			printf("(%s num=%d atr=%d %dx%d reg=%d regv=%p ln=%d ",
				opname(root->op), root->num,
				root->type.attr,
				root->type.dim, root->type.bits,
				root->reg, root->regvec,
				root->line);
			if ( root->symbol ) {
				printf("\"%s\" scope=%d,%d)\n",
					root->symbol->text,
					root->symbol->scope,
					root->symbol->serial);
			} else {
				printf ( "txt=N/A scope=N/A)\n" );
			}
			break;
		case 1: /* tree2fig */
			for ( i=tab; i; --i ) {
				printf ( " " );
			}
			printf ( "(%s %d %d %d %d %d ",
				 opname(root->op), root->num,
				 root->type.attr,
				 root->type.dim, root->type.bits,
				 root->line
				 );
			if ( root->symbol ) {
				printf ( "\"%s\" %d %d)\n",
					 root->symbol->text,
					 root->symbol->scope,
					 root->symbol->serial);
			} else {
				printf ( "\"\" -1 -1)\n" );
			}
			break;
	}

	if (order == IR_DNRT) {
		if ( root->down ) {
			++tab;
			p_ir(root->down, order);
			--tab;
		}
		if ( root->right ) {
			p_ir(root->right, order);
		}
	} else {
		/* order == IR_RTDN */
		if ( root->right ) {
			++tab;
			p_ir(root->right, order);
			--tab;
		}
		if ( root->down ) {
			p_ir(root->down, order);
		}
	}

	/* I (rjf) don't really like the extra lines, so I place a ')' at
	   the end of the entry instead of at the end of it's subtree instead
	   of doing this:
		for ( i=tab; i; --i ) {
			printf ( " " );
		}
		printf ( ")\n" );
	*/

	fflush (stdout);
}
#endif

