/*	spool.c

	Hack for register spilling.

	Support for generating code for spilling and retrieving register values
	and generating an array to hold them.

	There is not actual internal structure.  When spilling is done, a name
	is generated for the pseudo-register.
*/ 

#undef NOTDEFD

#include "stdpccts.h"
#include "swartypes.h"
#include "oputils.h"
#include "tuple.h"
#include "scheduler.h"
#include "spool.h"
#include "output.h"

int numspills;

int
maxspills(void)
{
	if (optcpu & CPU_AltiVec)
		return 24;
	else
		return 24;
}

static void
spoolinit32(void)
{
	/* We don't use a spill pool while generating straight C code */
	#ifdef NOTDEFD
		/* Declare the spill pool pointer */
		Ctab();
		fprintf(Cout, "extern p32_t spool32[];\n");
		Ctab();
		fprintf(Cout, "register p32_t *_spool = &(spool32[0]);\n\n");
	#endif
}

static void
spoolinit64(void)
{
	/* Declare the spill pool pointer */
	Ctab();
	fprintf(Cout, "extern p64_t spool64[];\n");
	Ctab();
	fprintf(Cout, "register p64_t *_spool = &(spool64[0]);\n\n");
}

static void
spoolinit128(void)
{
	/* Declare the spill pool pointer */
	Ctab();
	fprintf(Cout, "extern p128_t spool128[];\n");
	Ctab();
	fprintf(Cout, "register p128_t *_spool = &(spool128[0]);\n\n");
}

void
spoolinit(void)
{
	numspills = 0;

	switch (bitsperfrag()) {
	case 128:
		spoolinit128();
		break;
	case 64:
		spoolinit64();
		break;
	case 32:
		spoolinit32();
		break;
	}
}


char *
spoolname(int i)
{
	/* Generate an access of a value in the spill pool */

	/* Spilled registers are those with numbers greater or equal to
	   regsavail().  The special cases regsavail()-1, regsavail()-2, and
	   regsavail()-3 are reserved for swapping and are assigned the indices
	   1 and 0, respectively.  Thus, spool[0] and spool[1] are reserved for
	   swapping.
	*/
	static char spoolname[256];

	snprintf(&(spoolname[0]), 256, "*(_spool + %d)", i-(regsavail()-3));
	return(&(spoolname[0]));
}

static void
spooldump32(void)
{
	/* We're not using the spill pool while generating straight C code */
	#ifdef NOTDEFD
		fprintf(Cout, "\n/* SWAR spill pool */\n");
		fprintf(Cout, "p32_t spool32[%d];\n", maxspills()+3);
	#endif
}

static void
spooldump64(void)
{
	fprintf(Cout, "\n/* SWAR spill pool */\n");
	fprintf(Cout, "p64_t spool64[%d];\n", maxspills()+3);
}

static void
spooldump128(void)
{
	fprintf(Cout, "\n/* SWAR spill pool */\n");
	fprintf(Cout, "p128_t spool128[%d];\n", maxspills()+3);
}

void
spooldump(void)
{
	switch (bitsperfrag()) {
	case 128:
		spooldump128();
		break;
	case 64:
		spooldump64();
		break;
	case 32:
		spooldump32();
		break;
	}
}

