/*	swarc.h

	general header file....
*/


extern FILE	*Cout;		/* output C code */
extern FILE	*Hout;		/* output C interface header */

extern char	*sourcename;	/* source file name */
extern char	*funcname;	/* current function name */


/* CPU characteristics *******************************************************/
#define	CPU_MMX		16	/* CPU has MMX enhancements */
#define	CPU_RISC	32	/* CPU has RISC internals (avoid m2r addrs'g) */
#define	CPU_2PIPE	64	/* CPU has 2 MMX pipelines (not just 1) */
#define	CPU_3DNow	128	/* CPU has AMD 3DNow! enhancements */
#define	CPU_XMMX	256	/* CPU has Cyrix "extended MMX" enhancements */
#define	CPU_IPR		512	/* CPU has Intel Performance Registers */
#define	CPU_SSE		1024	/* CPU has Intel Streaming SIMD Extensions */
#define	CPU_MAX		2048	/* CPU has HP PA-RISC 2.0 MAX Extensions */
#define	CPU_athlon	4096	/* CPU has AMD Athlon enhancements */
#define	CPU_AltiVec	8192	/* CPU has PowerPC AltiVec enhancements */


/* CPU targets ***************************************************************/
/* Generic 32-bit Intel Architecture CPU */
#define	GenericIA32	(0)

/* "averaged" MMX model */
#define	GenericMMX	(CPU_MMX | CPU_2PIPE)

/* AMD K6 MMX; one pipe */
#define	K6		(1 | CPU_MMX )

/* AMD K6-2 MMX; 3DNow!, two pipes */
#define	K6_2		(2 | CPU_MMX | CPU_2PIPE | CPU_3DNow)

/* AMD K6-3 MMX; 3DNow!, two pipes */
#define	K6_3		(9 | CPU_MMX | CPU_2PIPE | CPU_3DNow)

/* AMD Athlon, two pipes */
#define	Athlon		(8 | CPU_MMX | CPU_2PIPE | CPU_3DNow | CPU_athlon)

/* Cyrix MII MMX */
#define	MII		(3 | CPU_MMX | CPU_XMMX | CPU_IPR)

/* Cyrix 6x86MX MMX */
#define	_6x86MX		(4 | CPU_MMX | CPU_XMMX | CPU_IPR)

/* Intel PentiumII MMX; two pipes */
#define	PentiumII	(5 | CPU_MMX | CPU_2PIPE | CPU_IPR)

/* Intel Pentium MMX; two pipes */
#define	PentiumMMX	(6 | CPU_MMX | CPU_2PIPE | CPU_IPR)

/* HP PA-RISC 2.0; RISC, ? pipes */
#define	PARISC2		(7 | CPU_MAX | CPU_RISC)

/* PowerPC AltiVec: RISC, ? pipes */
#define	AltiVec		(10 | CPU_AltiVec | CPU_RISC )




extern int	optcpu;		/* which flavor of CPU? */


extern int	optlines;	/* option to generate line directives */
extern int	opttime;	/* option to take this many seconds */
extern int	optperf;	/* option to output performance stats */
extern int	optverb;	/* option to output verbose info */
extern int	optir;		/* option to output a rep. of the IR */
extern int	optnofecf;	/* option to not const. fold in front-end */
extern int	optfebvt;	/* option to BVT on vectors in front-end */
extern int	optnobecf;	/* option to not const. fold in back-end */
extern int	optnobepeep;	/* option to not peephole optimize in the
				   back-end */


extern int	fieldcount;
extern int	fieldtotal;
extern int	clocktotal;


typedef struct {
	int	attr;		/* attributes of this type */
	int	bits;		/* bits per component value */
	int	dim;		/* how many component values */
} typ;


#define	TYP_NULL	0	/* Untyped */

#define	TYP_MOD		0	/* modular arithmetic (default) */
#define	TYP_SAT		1	/* saturation arithmetic */

#define	TYP_SIGN	0	/* signed (default) */
#define	TYP_UNSIGN	2	/* unsigned */

#define	TYP_VOID	4	/* void */
#define	TYP_CHAR	8	/* C char */
#define	TYP_SHORT	16	/* C short */
#define	TYP_INT		32	/* C int or long */
#define	TYP_LONG	64	/* C long */
#define	TYP_LLONG	128	/* C long long int */
#define	TYP_FLOAT	256	/* C float */

#define	TYP_SWAR	512	/* SWAR data of specified precision */

#define	TYP_FUNC	1024	/* Function (really subroutine) */

#define	TYP_STATIC	2048	/* Static (local to file scope) */
#define	TYP_EXTERN	4096	/* Extern (global defined elsewhere) */

#define	TYP_REG		8192	/* Register (just a suggestion) */
#define	TYP_CONST	16384	/* Const (read only) */
#define	TYP_LAB		32768	/* Label */


typedef struct {
	typ	type;		/* the symbol type */
	char	*text;		/* the symbol text */
	int	serial;		/* lexical serial number */
	int	scope;		/* scope number */
	int	declared;	/* SYM_DECLARED if declared, SYM_UNDECLARED if
				   not. */
	int	decline;	/* line in source where declared (or defined
				   if not declared) */
	int	used;		/* SYM_USED if used, SYM_UNUSED if not. */
} sym;


typedef struct _tree {
	struct _tree	*down;		/* down (child) */
	struct _tree	*right;		/* right (sibling) */
	int		op;		/* opcode */
	sym		*symbol;	/* symbol reference */
	int		num;		/* number value */
	typ		type;		/* type of node result */
	int		reg;		/* register assigned */
	int		*regvec;	/* where are these things? */
	int		line;		/* source line number */
} tree;


typedef union {
	char	*text;		/* lexeme text */
	sym	*symbol;	/* symbol reference */
	int	num;		/* integer number value */
	double	fnum;		/* float number value */
	tree	*node;		/* node in tree */
} Attrib;

#define zzdef0(a)	{ /* nothing */ }
#define zzd_attr(a)	{ /* nothing */ }

