/*	sym.h

	Stuff for managing the symbol table.  This is a bit
	funky in that it marks each entry not only with the
	scope (depth) number, but also with a lexical block
	serial number.  This old trick allows us to keep the
	whole symbol table around, including items that are no
	longer visible.  For now, this uses slow linear search,
	but it could easily use hashing if speed is a problem.
*/


#define SYM_UNDECLARED	0
#define SYM_DECLARED	1

#define SYM_UNUSED	0
#define SYM_USED	1


extern sym	symtab[4096];		/* Symbol table */
extern sym	*symptr;		/* Pointer to next free entry */
extern typ	curtyp;			/* Current type */

extern int	curscope;		/* Current scope depth */


extern sym *
enter(register char *s, int used);

extern sym *
lookup(register char *s);

extern sym *
thiscope(register char *s);

extern void
newscope(void);

extern void
endscope(void);

extern void
showunused(void);

extern void
showunusedstatics(void);

extern sym *
undeclared(char *name);
