/*	tuple.h

	Tuple support declarations.
*/

#include "stdpccts.h"


/*	leave BROKEN_PAND defined if using GCC with a version of
	GAS that does not correctly handle the pand operation;
	this flag has the effect of using pandn sequences instead
	of pand, often with no penalty, whereas the "faked" pand
	always has a several instruction penalty.
*/
#define	BROKEN_PAND
#undef	BROKEN_PAND

typedef struct _tuple {
	typ	type;		/* type (from original object) */
	int	op;		/* opcode */
	int	arg[3];		/* argument index values */
	sym	*symbol;	/* for load/store */
	int	fragment;	/* vector fragment number for load/store */
	int	offset;		/* bytes into a fragment, for load/store */
	p128_t	immed;		/* immediate value */
	int	antidep;	/* antidependent load */
	int	refs;		/* ref count */
	int	trefs;		/* temporary ref count */
	int	depth;		/* depth for code scheduling */
	int	after;		/* minimum instructions after this */
	int	before;		/* minimum instructions before this */
	int	reg;		/* mm register holding this value */
	int	oreg;		/* original reg (before mov insert) */
	int	m2rmode;	/* memory-to-register mode arg[1] */
	int	spilled;	/* tuple that spilled this */
	int	spillreg;	/* the register it used to be in */
} tuple;

#define	MAXTUP	(3 * 1024)	/* maximum number of tuples (previously 2k) */
				/* 4k is too large -> causes segfault */

