/*	immed.c

	Tuple generation for immediate fragments
*/

#include "swartypes.h"
#include "tuple.h"
#include "oputils.h"
#include "scheduler.h"
#include "tuplegen.h"
#include "tuple_immed.h"
#include "tuple_binop.h"
#include "Libstdswar/stdswar.h"

int
immedu(p128_t t)
{
	switch (bitsperfrag()) {
	case 128:
                return immed128(t);
	case 64:
                return immed64u((p64_t)t.uq[0]);
	case 32:
                return immed32u((p32_t)t.ud[0]);
	default:
		return immed128(t);
	}
}

int
immeds(p128_t t)
{
	switch (bitsperfrag()) {
	case 128:
                return immed128(t);
	case 64:
                return immed64s((p64_t)t.q[0]);
	case 32:
                return immed32s((p32_t)t.d[0]);
	default:
		return immed128(t);
	}
}

int
immed32s(p32_t t)
{
	/* Sign-extend the 32-bit value of "t" to 128 bits,
	   and form an immediate tuple.
	*/

	register int i;
	p128_t sign;

	sign.ud[3] = sign.ud[2] = sign.ud[1] = ~(-(!(t.ud & 0x80000000U)));

	/* Reuse an existing immediate value? */
	for (i=0; i<tupsp; ++i) {
		if ((tup[i].op == NUM) &&
		    (tup[i].immed.q[1] == sign.q[1]) &&
		    (tup[i].immed.d[1] == sign.d[1]) &&
		    (tup[i].immed.d[0] == t.d)) {
			return(i);
		}
	}

	/* Nope */
	tup[tupsp].op = NUM;
	tup[tupsp].type = typconst;
	tup[tupsp].immed.q[1] = sign.q[1];
	tup[tupsp].immed.d[1] = sign.d[1];
	tup[tupsp].immed.d[0] = t.d;
	tup[tupsp].refs = 0;
	tup[tupsp].arg[0] = -1;
	tup[tupsp].arg[1] = -1;
	tup[tupsp].arg[2] = -1;
	return(tupsp++);
}

#define immed32(t)	immed32u(t)

int
immed32u(p32_t t)
{
	/* Zero-extend the 32-bit value of "t" to 128 bits,
	   and form an immediate tuple.
	*/

	register int i;

	/* Reuse an existing immediate value? */
	for (i=0; i<tupsp; ++i) {
		if ((tup[i].op == NUM) &&
		    (tup[i].immed.q[1] == 0ULL) &&
		    (tup[i].immed.d[1] == 0) &&
		    (tup[i].immed.d[0] == t.d)) {
			return(i);
		}
	}

	/* Nope */
	tup[tupsp].op = NUM;
	tup[tupsp].type = typconst;
	tup[tupsp].immed.q[1] = 0ULL;
	tup[tupsp].immed.d[1] = 0;
	tup[tupsp].immed.d[0] = t.d;
	tup[tupsp].refs = 0;
	tup[tupsp].arg[0] = -1;
	tup[tupsp].arg[1] = -1;
	tup[tupsp].arg[2] = -1;
	return(tupsp++);
}


int
immed64s(p64_t t)
{
	/* Sign-extend the 64-bit value of "t" to 128 bits,
	   and form an immediate tuple.
	*/

	register int i;
	p128_t sign;

	sign.q[1] = ~(-(!(t.uq & 0x8000000000000000ULL)));

	/* Reuse an existing immediate value? */
	for (i=0; i<tupsp; ++i) {
		if ((tup[i].op == NUM) &&
		    (tup[i].immed.q[1] == sign.q[1]) &&
		    (tup[i].immed.q[0] == t.q)) {
			return(i);
		}
	}

	/* Nope */
	tup[tupsp].op = NUM;
	tup[tupsp].type = typconst;
	tup[tupsp].immed.q[1] = sign.q[1];
	tup[tupsp].immed.q[0] = t.q;
	tup[tupsp].refs = 0;
	tup[tupsp].arg[0] = -1;
	tup[tupsp].arg[1] = -1;
	tup[tupsp].arg[2] = -1;
	return(tupsp++);
}

int
immed64u(p64_t t)
{
	/* Zero-extend the 64-bit value of "t" to 128 bits,
	   and form an immediate tuple.
	*/

	register int i;

	/* Reuse an existing immediate value? */
	for (i=0; i<tupsp; ++i) {
		if ((tup[i].op == NUM) &&
		    (tup[i].immed.q[1] == 0ULL) &&
		    (tup[i].immed.q[0] == t.q)) {
			return(i);
		}
	}

	/* Nope */
	tup[tupsp].op = NUM;
	tup[tupsp].type = typconst;
	tup[tupsp].immed.q[1] = 0LL;
	tup[tupsp].immed.q[0] = t.q;
	tup[tupsp].refs = 0;
	tup[tupsp].arg[0] = -1;
	tup[tupsp].arg[1] = -1;
	tup[tupsp].arg[2] = -1;
	return(tupsp++);
}


#define immed128s(t)	immed128(t)
#define immed128u(t)	immed128(t)

int
immed128(p128_t t)
{
	/* Form a 128-bit immediate tuple */

	register int i;

	/* Reuse an existing immediate value? */
	for (i=0; i<tupsp; ++i) {
		if ((tup[i].op == NUM) &&
		    (tup[i].immed.q[0] == t.q[0]) &&
		    (tup[i].immed.q[1] == t.q[1])) {
			return(i);
		}
	}

	/* Nope */
	tup[tupsp].op = NUM;
	tup[tupsp].type = typconst;
	tup[tupsp].immed = t;
	tup[tupsp].refs = 0;
	tup[tupsp].arg[0] = -1;
	tup[tupsp].arg[1] = -1;
	tup[tupsp].arg[2] = -1;
	return(tupsp++);
}

