/*	tuple_trinop.c

	trinary operations on fragment tuples
*/
#undef NOTDEFD

#include "swartypes.h"
#include "tuple.h"
#include "tokens.h"
#include "scheduler.h"
#include "tuplegen.h"
#include "tuple_immed.h"
#include "tuple_binop.h"
#include "messages.h"
#include "showir.h"
#include "Libstdswar/stdswar.h"



int
trinop8u(int op,
int arg0,
int arg1,
int arg2)
{
	/* 8-bit unsigned field trinary ops */
	/* Convert the op into a tree of subpos if necessary for the target,
	   then strip the type information from the op to indicate that it has
	   been handled.
	*/
	switch (op) {
	case TPERM:
		if (optcpu & CPU_AltiVec) {
			break;
		} else {
			bug("Trinary TPERM not available on this target");
		}

	default:
	{
		char buf[64];
		snprintf(buf,
			 64,
			 "trinop8u op=%s (this cannot happen?)",
			 opname(op));
		bug(buf);
	}
	}

	return(-1);
}

int trinop8us(int op, int arg0, int arg1, int arg2)
{
	bug("Function not implemented");
	return 0;
}

int trinop8(int op, int arg0, int arg1, int arg2)
{
	bug("Function not implemented");
	return 0;
}

int trinop8ss(int op, int arg0, int arg1, int arg2)
{
	bug("Function not implemented");
	return 0;
}


int
trinop16u(int op,
int arg0,
int arg1,
int arg2)
{
	/* 16-bit unsigned field trinary ops */
	/* Convert the op into a tree of subpos if necessary for the target,
	   then strip the type information from the op to indicate that it has
	   been handled.
	*/
	switch (op) {
	default:
	{
		char buf[64];
		snprintf(buf,
			 64,
			 "trinop16u op=%s (this cannot happen?)",
			 opname(op));
		bug(buf);
	}
	}

	return(-1);
}

int trinop16us(int op, int arg0, int arg1, int arg2)
{
	bug("Function not implemented");
	return 0;
}

int trinop16(int op, int arg0, int arg1, int arg2)
{
	bug("Function not implemented");
	return 0;
}

int trinop16ss(int op, int arg0, int arg1, int arg2)
{
	bug("Function not implemented");
	return 0;
}


int
trinop32u(int op,
int arg0,
int arg1,
int arg2)
{
	/* 32-bit unsigned field trinary ops */
	/* Convert the op into a tree of subpos if necessary for the target,
	   then strip the type information from the op to indicate that it has
	   been handled.
	*/
	switch (op) {
	default:
	{
		char buf[64];
		snprintf(buf,
			 64,
			 "trinop32u op=%s (this cannot happen?)",
			 opname(op));
		bug(buf);
	}
	}

	return(-1);
}

int trinop32us(int op, int arg0, int arg1, int arg2)
{
	bug("Function not implemented");
	return 0;
}

int trinop32(int op, int arg0, int arg1, int arg2)
{
	bug("Function not implemented");
	return 0;
}

int trinop32ss(int op, int arg0, int arg1, int arg2)
{
	bug("Function not implemented");
	return 0;
}

int trinop32f(int op, int arg0, int arg1, int arg2)
{
	bug("Function not implemented");
	return 0;
}

